% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inputs.R
\name{fit_spend_exposure}
\alias{fit_spend_exposure}
\title{Fit a nonlinear model for media spend and exposure}
\usage{
fit_spend_exposure(dt_spendModInput, mediaCostFactor, paid_media_var)
}
\arguments{
\item{dt_spendModInput}{data.frame. Containing channel spends and
exposure data.}

\item{mediaCostFactor}{Numeric vector. The ratio between raw media
exposure and spend metrics.}

\item{paid_media_var}{Character. Paid media variable.}
}
\value{
List. Containing the all spend-exposure model results.
}
\description{
This function is called in \code{robyn_engineering()}. It uses
the Michaelis-Menten function to fit the nonlinear model. Fallback
model is the simple linear model \code{lm()} in case the nonlinear
model is fitting worse. A bad fit here might result in unreasonable
model results. Two options are recommended: Either splitting the
channel into sub-channels to achieve better fit, or just use
spend as \code{paid_media_vars}
}
