% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_order_status_options.R
\name{get_order_status_options}
\alias{get_order_status_options}
\title{Get a current status of an option order on RobinHood}
\usage{
get_order_status_options(RH, status_url)
}
\arguments{
\item{RH}{object of class RobinHood}

\item{status_url}{(string) url of order returned from place_order}
}
\description{
Returns a list of order information given a buy/sell order url returned from place_order_options().
}
\examples{
\dontrun{
# Login in to your RobinHood account
RH <- RobinHood("username", "password")

# Place an order, should generate an email confirmation
x <- place_order_options(RH = RH,
                       option_id = "346e46af-380e-4052-a7c2-15748f0fc0ca",
                       direction = "debit",   # one of "debit" or "credit"
                       side = "buy",          # one of "buy" or "sell"
                       quantity = 1,          # number of contracts
                       stop_price = .01,      # Time period (gfd: good for day)
                       type = "limit",        # limit or market (only limit is currently supported)
                       time_in_force = "gtc") # "gfd", "gtc", "ioc", "opg"

get_order_status_options(RH, x$status_url)
}
}
