% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robin_lm.R
\name{robin_lm}
\alias{robin_lm}
\title{Covariate adjusted lm model}
\usage{
robin_lm(
  formula,
  data,
  treatment,
  vcov = "vcovG",
  vcov_args = list(),
  pair,
  ...
)
}
\arguments{
\item{formula}{(\code{formula}) A formula of analysis.}

\item{data}{(\code{data.frame}) Input data frame.}

\item{treatment}{(\code{formula} or \code{character(1)}) A formula of treatment assignment or assignment by stratification,
or a string name of treatment assignment.}

\item{vcov}{(\code{function}) A function to calculate the variance-covariance matrix of the treatment effect,
including \code{vcovHC} and \code{vcovG}. The default is 'vcovG'.}

\item{vcov_args}{(\code{list}) Additional arguments passed to \code{vcov}.}

\item{pair}{Pairwise treatment comparison.}

\item{...}{Additional arguments passed to \code{lm}.}
}
\value{
A treatment_effect object.
}
\description{
Covariate adjusted lm model
}
\examples{
robin_lm(
  y ~ treatment * s1,
  data = dummy_data,
  treatment = treatment ~ s1
)
}
