% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robincar-covhr.R
\name{robincar_covhr}
\alias{robincar_covhr}
\title{Covariate-adjusted estimators for time to event data}
\usage{
robincar_covhr(
  df,
  treat_col,
  response_col,
  event_col,
  car_strata_cols = NULL,
  covariate_cols = NULL,
  p_trt = 0.5,
  ref_arm = NULL,
  car_scheme = "simple",
  adj_method = "CL",
  interval = c(-10, 10)
)
}
\arguments{
\item{df}{A data.frame with the required columns}

\item{treat_col}{Name of column in df with treatment variable}

\item{response_col}{Name of the column in df with response variable}

\item{event_col}{Name of column in df with event indicator
(0/FALSE=no event, 1/TRUE=event)}

\item{car_strata_cols}{Names of columns in df with car_strata variables}

\item{covariate_cols}{Names of columns in df with covariate variables}

\item{p_trt}{Treatment allocation ratio for the reference arm.}

\item{ref_arm}{Reference arm of the treatment group, defaults to NULL,
which results in using the first element of `unique(data[, treat_col])`.}

\item{car_scheme}{Name of the type of covariate-adaptive randomization scheme. One of: "simple", "pocock-simon", "biased-coin", "permuted-block".}

\item{adj_method}{Adjustment method (one of "CL", "CSL")}

\item{interval}{Interval for uniroot function}
}
\value{
An object with attribute named "result", which lists:

\item{theta_L}{estimate of the hazard ratio}
\item{se_theta_L}{SE estimate of the hazard ratio}
\item{theta_CL}{estimate of the covariate-adjusted hazard ratio}
\item{se_theta_CL}{SE estimate of the covariate-adjusted hazard ratio}

Other attributes are the settings used, data attributes, and the original data frame supplied by the user.
}
\description{
Estimate a covariate-adjusted hazard ratio (`adj_method="CL"`),
or a covariate-adjusted stratified hazard ratio (`adj_method="CSL"`).
}
