% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctrynldata.R
\name{getCtryNlDataFname}
\alias{getCtryNlDataFname}
\title{Construct the name of the country data file.}
\usage{
getCtryNlDataFname(ctryCode, admLevel,
  gadmVersion = pkgOptions("gadmVersion"), custPolyPath = NULL)
}
\arguments{
\item{ctryCode}{The ctryCode of interest}

\item{admLevel}{The country admin level of interest}

\item{gadmVersion}{The GADM version to use}

\item{custPolyPath}{Alternative to GADM. A path to a custom shapefile zip}
}
\value{
Character filename of the country data file
}
\description{
Construct the name of the data file. This function can be altered to name the file as 
    required and consistently retrieve the name. Used in the function getCtryNlDataFnamePath 
    to concat the directory path and this filename. Currently all nlTypes are stored in one 
    file. Can be altered to separate VIIRS and OLS data files for example.
}
\examples{
ctryCode <- "KEN"
admLevel <- "KEN_adm0"
Rnightlights:::getCtryNlDataFname(ctryCode, admLevel)
#returns string of name of the ctry data file

}
