% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rte_analyze_tex_file.R
\name{rte.analyze.tex.file}
\alias{rte.analyze.tex.file}
\title{Analyze a LaTeX file and convert it into a list}
\usage{
rte.analyze.tex.file(f.in, latex.dir.out = "latexOut",
  pdf.dir.out = "PdfOut")
}
\arguments{
\item{f.in}{The latex file with the exam}

\item{latex.dir.out}{The name of the folder where the files from the latex
compilation should go (will create if not found)}

\item{pdf.dir.out}{The name of the folder where the pdf from the latex
compilation should go (will create if not found)}
}
\value{
A list that represents the tex file with preamble, questions, answers
  and more. This list is later used by function rte.build.rdn.text \describe{
  \item{df.questions}{A data.frame with all questions} \item{df.answers}{A
  data.frame with all answers} \item{my.begin.mchoice.line}{text with
  beggining of mchoice enviroment} \item{my.preamble}{preamble of tex file,
  including everything before the beggining of the multiple choice enviroment
  } \item{my.last.part}{All of the tex code after the end of the multiple
  choice enviroment } }
}
\description{
This function will take as input a LaTeX file and break its components into a
single R List. The class of the latex file should be either exam or examdesign.
The code identifies the latex class automatically.
}
\examples{
latex.dir.out <- 'latexOut' # Name of folder where latex files are going
                            #(will create if it does not exists)

pdf.dir.out <- 'PdfOut'     # Name of folder where resulting pdf files are going

# Get latex example from package
f.in <- system.file("extdata", "MyRandomTest_examdesign.tex", package = "RndTexExams")

# Break latex file into a R list
list.out <- rte.analyze.tex.file(f.in,
                                latex.dir.out = latex.dir.out,
                                pdf.dir.out = pdf.dir.out)

print(list.out)
}

