\name{navGraph}
\alias{navGraph}

\title{
  Start an navGraph session
}

\description{
  \code{navGraph} is an interactive data visualization program that lets
  the user explore high dimensional data by using graphs as a "road
  map". That is, \code{navGraph} connects a bullet on a graph to some
  user specified visualization of some data.

  The package is discussed in detail in our vignette, see
  \code{vignette("RnavGraph")}.
}

\usage{
navGraph(data, graph = NULL, viz = NULL, settings = NULL)
}

\arguments{
  \item{data}{
    a single- or a \code{list} of objects generated by the
    \code{\link{ng_graph}} function. I.e. objects from the NG_data
    class.
    
    Two special cases are:\cr
    - either a \var{navGrah handler} to reinitialize a \code{navGraph}
    session.\cr
    - or the sting \code{tclreset} to delete \emph{tk2d} related
    settings and data.    
  }
  \item{graph}{
    a single- or a \code{list} of objects generated by the
    \code{\link{ng_graph}} function. I.e. objects from the NG_data class.
  }
  \item{viz}{
    a single- or a \code{list} of visualization instruction objects
    generated for example by \code{\link{ng_2d}} or \code{\link{ng_2d_myplot}}
    function. I.e. objects from the NG_visualization class.
  }
  \item{settings}{
    a list of pailists. See details.
  }
}

\details{
  The \pkg{RnavGraph} package comes with an extensive package vignette
  which we encourage to read.
  
  \code{navGraph} is capable to handle multiple graphs where each graph
  can be connected to multiple data displays. 

  \code{navGraph} needs to know the data to be explored, the graph whose
  node represent some low dimensional visualization of the data and some
  visualization instructions which connect the graph and data. Data,
  graph and visualization instruction have their own wrapper class
  provided by the \pkg{RnavGraph} package. See \code{\link{ng_data}},
  \code{\link{ng_graph}} and for the visualization instructions
  \code{\link{ng_2d}}.

  There are several shortcuts to start a \code{navGraph} session. All of
  them assume that the nodes of the graphs represent 2d scatterplots and
  the edges 3d rigid rotation or a 4d transition of one scatterplot into
  another. The easiest of them is to only pass by a data object created
  with the \code{\link{ng_data}} function. For the other ways consult
  the vignette.

  The \code{settings} argument modifies the default appearance and
  interaction properties of the \code{navGraph} user interface. It must
  be a list of named (names are: color, interaction, display and tk2d)
  lists containing \code{tag=value} pairs. To get the possible
  \code{tag=value} options, study the class definitions of the
  \code{ColorSettings}, \code{InteractionSettings},
  \code{DisplaySettings} and \code{Tk2dDisplay} classes with the
  \code{getClassDef} function. See the examples section below for an example.

}


\value{ A navGraph handler which can be used to interface the
  \code{navGraph} session via the R prompt. Use \code{\link{ng_get-methods}} to
  get data from the function.

  Use \code{\link{ng_update}} to update the navGraph handler with the
  current state of its associated \code{navGraph} session. If you have
  changed some attributes such as color or size in the tk2d
  display, you can get the new grouping with
  \code{ng_get(ng_get(nav,"data"),"group")} back, where \var{nav} is the
  navGraph handler.  }

%%\references{
  %% ~put references to the literature/web site here ~
%%}
\author{
  Adrian Waddell and R. Wayne Oldford
}
%%\note{
%%  ~~further notes~~
%%}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
\code{\link{ng_data}}, \code{\link{ng_graph}}, \code{\link{ng_2d}},
\code{\link{ng_2d_myplot}},
\code{\link{scagNav}}, \code{\link{ng_get-methods}}, \code{\link{ng_set-methods}},
\code{\link{ng_update}}, \code{\link{ng_walk}}, \code{\link{ng_set_color<-}}, \code{\link{ng_get_color}},  \code{\link{ng_set_size<-}}, \code{\link{ng_get_size}}
}
\examples{
## Define a NG_data object
ng.iris <- ng_data(name = "iris", data = iris[,1:4],
		shortnames = c('s.L', 's.W', 'p.L', 'p.W'),
		group = iris$Species,
		labels = substr(iris$Species,1,2))

## Start navGraph
\donttest{nav1 <- navGraph(ng.iris)}

## navGraph session, data linked to previous session
\donttest{nav2 <- navGraph(ng.iris, settings =
   list(color=list(background="steelblue",bullet="blue"),
   interaction=list(NSteps=11)))}

## navGraph session, data is not linked
\donttest{nav3 <- navGraph(ng.iris, settings=list(tk2d=list(linked=FALSE))}



}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ dynamic }
\keyword{ graphs }
\keyword{ multivariate }
\keyword{ classif }
