% Check from R:
%  news(db = tools:::.build_news_db_from_package_NEWS_Rd("~/R/Pkgs/Rmpfr/inst/NEWS.Rd"))
\name{NEWS}
\title{Rmpfr News}
\encoding{UTF-8}

\section{Changes in version 0.8-4 [2021-03-24, r341]}{
  \subsection{NEW FEATURES}{
    \itemize{
      \item \code{dpois(x, *)} now also gets an explicit optional argument
      \code{useLog} instead of just switching to log-scale by the same
      test as defines \code{useLog}'s default.

      \item The default method of \code{mpfr(r)} now also works when
      \code{r} is a \code{list} of \code{"mpfr1"} objects, e.g., resulting
      from \code{Vectorize(.)} or similar applied to mpfr-vectors.
    }
  }
  \subsection{BUG FIXES}{
    \itemize{
      \item fixed problem detected by clang-UBSAN testing in \file{src/Ops.c}
      (from arithmetic bug fix in 0.8-3). % ../tests/arith-ex.Rout_clang-UBSAN
    }
  }
}

\section{Changes in version 0.8-3 [2021-03-22, r340]}{
  \subsection{NEW FEATURES}{
    \itemize{
      \item \code{dnbinom(x, *)} and \code{dbinom(x, *)} now also work when
      \code{x} is too large to be coerced to \code{integer} \emph{and} they
      get a new optional argument \code{useLog} (with a smart default) in
      order to choose log-scale computation also for \code{log=FALSE}.
      %% FIXME:  add tests/* :  dnbinom(1e300, prob=1-mpfr(2, 256)^-12, %% size=1e307,log=TRUE)
    }
  }
  \subsection{BUG FIXES}{
    \itemize{
      \item For arithmetic (\code{`+`}, \code{`*`}, etc), the check to see
      if a numeric can be validly coerced to a long has been amended such
      that 9223372036854775808 is no longer accidentally coerced into
      \emph{negative}.

      \item \code{dpois(x, lambda)} now works via log-scale in case
      \code{exp(-lambda)} or \code{lambda^x} would under- or overflow even
      for mpfr-numnbers.

      Analogously, \code{dbinom()} and \code{dnbinom()} work via log-scale
      in case even mpfr-arithmetic would overflow.
    }
  }
}

\section{Changes in version 0.8-2 [2020-11-10, r337]}{
  \subsection{NEW FEATURES}{
    \itemize{
      \item The workhorse for all matrix multiplication (\code{\%*\%},
      \code{crossprod()}, and \code{tcrossprod()}), i.e., \code{.matmult.R(x, y, *)}
      (not exported), gets new optional arguments \code{fPrec = 1} and
      \code{precBits}, which defaults to the maximum of \code{getPrec(x)}
      and \code{getPrec(y)}.
      To get correct \code{crossprod()} and tcrossprod() generics (with a
      formal \code{\dots} argument), need a new \CRANpkg{gmp} release, as
      we get these two generics from \pkg{gmp}.

      \item \code{matmult(x,y)} is identical to \code{x \%*\% y}, but
      \code{matmult()} has further optional arguments \code{fPrec} and
      \code{precBits}, see above.

      \item New \code{is.mpfr(x)} function; simple, with fast pre-test.

      \item In \code{pbetaI(q, ..)}, when \code{q} is a bigrational, i.e.,
      of class \code{"bigq"} (package \CRANpkg{gmp}), the computations are
      \emph{exact} now, using big rational arithmetic.

      \item New \code{dnbinom()} function (with corresponding new
      \code{\link{conflicts}()} with the \pkg{stats} package base \R
      function), providing an \code{"mpfr"}-number version of the negative
      binomial probabilities.

      \item \code{.mpfr_erange_set()} now can set \emph{both} exponent
      range limits simultaneously, and now returns invisibly \code{TRUE} if
      the change succeeded.

      \item New \code{log1mexp()} and \code{log1pexp()}, as "from"
      \CRANpkg{copula}, notably as the vignette has been here, and authored
      by me.
    }
  }
  \subsection{BUG FIXES}{
    \itemize{
      \item \code{mpfr(mm)} (and similar) now works for \code{"bigq"} or
      \code{"bigz"} matrices, thanks to a report by Jerry Lewis.

      \item Arithmetic and other \code{"\link{Ops}"} between \code{"mpfr"}
      and \code{"bigq"} aka bigrational numbers, now use the
      \dQuote{inherent} precision of the bigrational.

      \item \code{chooseMpfr(a, n)} and similar now \dQuote{work} when
      \code{n} is of length zero \emph{and} when an experimental version of
      \code{stopifnot(*, allow.logical0=FALSE)} is used.

      \item Our \code{cbind()} and \code{rbind()} methods with
      \code{signature = "mNumber"} now keep and construct column and row
      names as the corresponding base functions, obeying
      \code{deparse.level}.

      \item Fixed "not-yet"-as-cran \file{NOTE}
      \emph{Undeclared packages \pkg{dfoptim}, \pkg{pracma} in Rd xrefs}.
    }
  }
}

\section{Changes in version 0.8-1 [2020-01-14, r323]}{
  \subsection{BUG FIXES}{
    \itemize{
      \item Provide dummy C function in the case MPFR library is older than
      3.2.0, thanks to Brian Ripley.  Should work around check \code{NOTE}s.
    }
  }
}

\section{Changes in version 0.8-0 [2019-12-05, r321]}{
  \subsection{USER-VISIBLE CHANGES}{
    \itemize{
      \item Formatting incl \code{print()}ing by default uses a \code{"+"}
      after the exponential character (\code{"e"} by default).
    }
  }
  \subsection{NEW FEATURES}{
    \itemize{
      \item Provide new low-level utilities \code{.mpfr_formatinfo()},
      \code{.mpfr2exp()}, and \code{.mpfr_erange_is_int()}.

      \item Renamed low-level utility functions to use \code{_} instead of
      \code{.} keeping initial \code{"."}, e.g.,
      \code{.mpfr.gmp.numbbits()} to \code{.mpfr_gmp_numbbits()}.

      \item \code{formatMpfr()} gets a new optional \code{decimal.plus = TRUE} which
      adds a \code{"+"} before positive exponents when in exponential (aka
      \dQuote{scientific}) representation.

      The \code{mpfr} and \code{mpfrArray} \code{print()} methods get
      a corresponding \code{decimal.plus} argument with a default that can
      be set by \code{options(Rmpfr.print.decimal.plus = *)} to allow
      strict back compatibility where needed.

      \item For MPFR (C library) version >= 3.2.0 (not by default in Fedora 30!),
      provide the \emph{incomplete} gamma function \code{igamma(a,x)}
      which is closely related to \code{pgamma(x,a)}, see help page.% and DO
      % provide an MPFR pgamma() version, too
      %  ==> then even MPFR pchisq() with *non*centrality maybe!

      \item Now also export S3 method of \code{unique()} for \code{"mpfr"},
      such that \pkg{base} \code{factor(<mpfr>)} \dQuote{works}.% -> ../man/mpfr-class.Rd
    }
  }
  \subsection{BUG FIXES}{
    \itemize{
      \item \code{formatMpfr()} and hence all \code{print()}ing suffered
      from an integer overflow bug with very large (base 2) exponents.

      \item \code{.mpfr2str(x, *)} is no longer dependent on the
      \emph{order} of the elements in \code{x}; consequently
      \code{format()} and \code{print()} may use less digits in case the
      precision decreases along \code{x}.

      \item adapt to new C compiler default behavior \code{-fno-common},
      using \code{extern #include <Syms.h>} in most \file{*.c} files.
    }
  }
}

\section{Changes in version 0.7-3 [2019-08-06, r305]}{
  \subsection{USER-VISIBLE CHANGES}{
    \itemize{
      \item Decreased the default for \code{max.digits} to 999.
    }
  }
  \subsection{NEW FEATURES}{
    \itemize{
      \item Provide \code{dgamma(x, shape)} version, e.g., for small shape
      parameter where most of the mass is on very small \code{x} not
      representable as double precision numbers.

      \item Low-level formatting function \code{.mpfr2str()} --- called by
      \code{format()} and hence \code{print()} methods for \code{"mpfr"}
      objects --- now finally obeys its \code{maybe.full} argument when it
      is \code{FALSE}, internally in C's \code{mpfr2str()}.
    }
  }
  \subsection{BUG FIXES}{
    \itemize{
      \item \code{pnorm(<large>, log.p=TRUE)} no longer underflows much too
      early, thanks to reports by Jerry Lewis.

      \item \code{print.mpfrArray()} now also uses a finite
      \code{max.digits} default, preventing, e.g., \code{cbind(x, y)} to
      use too many digits.
    }
  }
}

\section{Changes in version 0.7-2 [2019-01-18, r299]}{
  \subsection{BUG FIXES}{
    \itemize{
      \item \code{str(<mpfr>)} no longer calls \code{formatMpfr(x, digits, *)}
      with a \code{digits} \emph{vector} of the same length as \code{x}
      (which never worked correctly).

      \item \code{seqMpfr(1, length.out=8)} now works correctly.
    }
  }
  \subsection{NEW FEATURES}{
    \itemize{
      \item \code{unirootR()} gets an option to \emph{not} warn on
      non-convergence.

      \item Provide a \code{summary()} method for \code{"mpfr"} numbers
      closely modeled after \code{summary.default} for numeric.

      \item \code{mpfr(NULL)} now works, returning \code{mpfr(logical())}.

      \item a simple \code{sapplyMpfr()} function, showing how to work
      around the fact that \code{sapply()} does typically not work with
      \code{"mpfr"} numbers.
    }
  }
}


\section{Changes in version 0.7-1 [2018-07-24, r291]}{
  \subsection{BUG FIXES}{
    \itemize{
      \item \code{formatMpfr()} for large low-precision numbers now uses
      scientific representation, fixing the bug RMH was reporting March
      17 already.

      \item \code{outer()} is \dQuote{imported} from base, so it
      behaves as an \pkg{Rmpfr} function which dispatches e.g., when
      calling \code{\link{tcrossprod}()}.
    }
  }
}

\section{Changes in version 0.7-0 [2018-01-12, r284]}{
  \subsection{NEW FEATURES}{
    \itemize{
      \item \code{.mpfr2list()} and \code{mpfrXport()} gain an option
      \code{names} (for nicer output).

      \item \code{formatMpfr()} and the \code{print()} method get a new
      option \code{max.digits} with default \code{9999} for the print
      methods, to limit the number of digits printed for high precision
      numbers.
    }
  }
  \subsection{BUG FIXES}{
    \itemize{
      \item For non-\dQuote{regular} mpfr numbers, the \code{d} slot in
      the \code{"mpfr1"} representation is now empty instead of
      \dQuote{random}.   This also eliminates valgrind warnings about
      uninitialized values in C.
    }
  }
}
\section{Changes in version 0.6-2 [2017-05-29, r264], never on CRAN}{
  \subsection{NEW FEATURES}{
    \itemize{
      \item The S3 classes \code{"Hcharacter"} and \code{"Bcharacter"}
      resulting from \code{formatHex()} and \code{formatBin()} now
      \dQuote{inherit from} \code{"character"} formally.

      \item They also got a \code{`[`} method, so subsetting should
      work, including for \code{array}s of these.

      \item The \code{"mpfr"} method of \code{str()} gains option
      \code{internal}.
    }
  }
  \subsection{BUG FIXES}{
    \itemize{
      \item when \code{print()}ing mpfr numbers, the result no longer sometimes
      loses the last digit.

      \item \code{dnorm()} now works correctly with mpfr numbers;
      similarly \code{dbinom()} and \code{dpois()} should work in all
      cases, now.

      \item in \file{NAMESPACE}, also \code{exportMethods(apply)}, so
      \pkg{SNscan} works.

      \item \code{print(formatHex(..))}, \code{formatBin()} and
      \code{formatDec()} now look better and are more correct; the first
      two get a new option \code{expAlign} indicating to use the same
      number of digits for exponents (in \dQuote{scientific} cases).

      Notably, \code{mpfr(formatBin(mpx))} works for more \code{mpx}
      objects (of class \code{"mpfr"}).

      \item \code{format(mpfr(3,7), digits = 1, base = 2)} no longer
      crashes (from inside MPFR).

      \item \code{formatDec(mpfr(NA, 7))} now works.

      \item For non-\dQuote{regular} mpfr numbers, the \code{d} slot in
      the \code{"mpfr1"} representation is now empty instead of
      \dQuote{random}.   This also eliminates valgrind warnings about
      uninitialized values in C.
    }
  }
}

\section{Changes in version 0.6-1 [2016-11-15, r249]}{
  \subsection{NEW FEATURES}{
    \itemize{
      \item \code{head()} and \code{tail()} methods for \code{"mpfrMatrix"}.
    }
  }
  \subsection{BUG FIXES}{
    \itemize{
      \item C-level \code{mpfr2str()} no longer calls S_realloc() with
      wrong "old size" (thanks to Bill Dunlap).
      \item \code{c()} now also works when its result is a length-0
      \code{"mpfr"} object.
    }
  }
}

\section{Changes in version 0.6-0 [2015-12-04, r237]}{
  \subsection{NEW FEATURES}{
    \itemize{
      \item \code{mpfr()} now is S3 generic with several methods, notably a
      \code{"mpfr"} method allowing to change precision or rounding mode.

      \item \code{mpfr()}, \code{formatMpfr()}, etc, now work with bases from 2
      to 62 (using digits, upper and lower case ASCII letters, \code{62
      == 10 + 2*26} characters), as this has been in MPFR since version
      3.0.0 (see \code{\link{mpfrVersion}}), which is hence (implicitly)
      required for \code{base} greater than 36.

      \item \code{formatMpfr()} gets a new argument \code{base = 10} and can
      be used to produce in other bases, notably binary (\code{base = 2})
      or hexadecimal (\code{base = 16}).

      \item \code{str(<mpfr>, ....)} is now based on \code{formatMpfr()}
      and nicely shows numbers also out of the double precision range.

      Further, it now chooses a smart default for optional argument
      \code{vec.len}.

      \item \code{matrix(mp, ..)} now also works when \code{mp} is of
      class \code{"mpfr"}.
      \item new matrix \code{norm()} for several \code{kind}s.

      \item new functions \code{formatHex()} and \code{formatBin()}
      thanks to Rich Heiberger.

      \item \code{mpfr(x)} also works as \emph{inverse} of
      \code{formatBin} and \code{formatHex}.

      \item \code{roundMpfr()} and mathematical functions such as
      \code{jn}, or \code{chooseMpfr()} get new optional argument
      \code{rnd.mode} passed to the corresponding MPFR function.

      \item \code{median(x)}, \code{mean(x, trim)} for \code{trim > 0}
      now work fine for \code{"mpfr"} x, and \code{quantile(x, *)} no
      longer needs \code{names=FALSE} to avoid a warning.
    }
  }
  \subsection{BUG FIXES}{
    \itemize{
      \item \code{pnorm(.)}, \code{j0()} and similar special functions
      now preserve \code{mpfrMatrix} and \code{mpfrArray} classes.

      \item similarly, \code{is.finite()} etc keep the
      \code{dim()}ensionality for \code{"mpfrArray"} arguments.

      \item \code{mpfr("0xabc", base=16)} and \code{mpfr("0b101",
	base=2)} and corresponding \code{getPrec()} now give the correct
      precBits instead of too many.

      \item \code{str(<0-length mpfr>)} now works correctly.
    }
  }
}



\section{Changes in version 0.5-7 [2014-11-27, r205]}{
  \subsection{NEW FEATURES}{
    \itemize{
      \item .
    }
  }
  \subsection{BUG FIXES}{
    \itemize{
      \item \code{as.integer()} now rounds \dQuote{to zero} as for
      regular \R numbers (it accidentally did round \dQuote{to nearest}
      previously).
    }
  }
}

\section{Changes in version 0.5-6 [2014-09-05, r203]}{
  \subsection{NEW FEATURES}{
    \itemize{
      \item experimental \code{mpfrImport()}, \code{mpfrXport()}
      utilities -- as we found cases, where save() \code{"mpfr"} objects
      were \emph{not} portable between different platforms.

      \item \code{as(*,"mpfr")} now also supports rounding mode
      \code{"A"} (\dQuote{\bold{A}way from zero}).

      \item Several hidden low level utilities also get a
      \code{rnd.mode} option.
    }
  }
  \subsection{BUG FIXES}{
    \itemize{
      \item .
    }
  }
}

\section{Changes in version 0.5-5 [2014-06-19, r190]}{
  \subsection{NEW FEATURES}{
    \itemize{
      \item The result of \code{integrateR()} now prints even if a
      warning happened.

      \item \code{pbetaI(x, a,b)}, the arbitrarily accurate
      \code{pbeta()} computation for \emph{integer} \eqn{a} and \eqn{b},
      now works for larger \eqn{(a,b)}.

      \item Newly providing \code{mpfr}-versions of \code{dbinom()},
      \code{dpois()}, and \code{dnorm()}.

      \item New utility functions \code{mpfr_default_prec()},
      \code{.mpfr.minPrec()}, etc, to get, check, set default exponent
      ranges and precision.

      \item New \code{sinpi()}, \code{cospi()} etc, notably for \R >= 3.0.1.
    }
  }
  %% \subsection{BUG FIXES}{
  %%   \itemize{
  %%     \item .
  %%   }
  %% }
}

\section{Changes in version 0.5-4 [2013-10-22, r173]}{
  \subsection{NEW FEATURES}{
    \itemize{
      \item .
    }
  }
  \subsection{BUG FIXES}{
    \itemize{
      \item .
    }
  }
}


%% The first CRAN release
\section{Changes in version 0.1-5 [2009-08-06]}{
  \subsection{NEW FEATURES}{
    \itemize{
      \item First CRAN release on 'Publication:' 2009-08-14 20:24:02

      \item new \code{pmin()} and \code{pmax()}, improving \code{seqMpfr()}.

      \item new \code{"Math"} and \code{"Math2"} group methods, notably for
      \code{round()} and \code{signif()}.

      \item \code{as(. , "integer")} now works (via C \code{mpfr2i}).
    }
  }
  \subsection{More details for old versions up to Feb. 2015:}{
    \itemize{
      \item See file \file{ChangeLog} %% ../ChangeLog <<<
    }
  }
}
