\name{surveydetails}
\alias{surveydetails}
\title{Get survey details}
\description{Get details about a specific survey}
\usage{
surveydetails(survey, api_key = getOption('sm_api_key'),
              oauth_token = getOption('sm_oauth_token'))
}
\arguments{
\item{survey}{A Survey Monkey survey ID number (or an object of class \dQuote{sm_survey} from which it can be extracted), possibly returned by \code{\link{surveylist}}.}
\item{api_key}{Your API key. By default, retrieved from \code{getOption('sm_api_key')}.}
\item{oauth_token}{Your OAuth 2.0 token, as generated by \code{\link{smlogin}}. By default, retrieved from \code{getOption('sm_oauth_token')}.}
%  \item{...}{Other arguments. Currently ignored.}
}
\details{Retrieves details of a specified survey (e.g., question metadata). Surveys with over 200 survey pages will not be returned. Surveys with over 200 questions will not be returned.}
\value{A list of objects of class \code{sm_survey}.}
\references{
\url{https://developer.surveymonkey.com/mashery/get_survey_details}
}
\author{Thomas J. Leeper}
%\note{}
%\seealso{}
\examples{
\dontrun{
smlogin()
s <- surveylist()
surveydetails(s[[1]]$survey_id)
}
}
%\keyword{}
