% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02-harmo_process_harmonization.R
\name{dataschema_extract}
\alias{dataschema_extract}
\title{Generate a DataSchema based on Data Processing Elements}
\usage{
dataschema_extract(data_proc_elem)
}
\arguments{
\item{data_proc_elem}{A Data Processing Elements object.}
}
\value{
A list of data frame(s) named 'Variables' and (if any) 'Categories', with
\code{Rmonize::class} 'dataschema'.
}
\description{
Generates a DataSchema from a Data Processing Elements.
}
\details{
The Data Processing Elements specifies the algorithms used to process input
variables into harmonized variables in the DataSchema format. It is also
contains metadata used to generate documentation of the processing.
A Data Processing Elements object is a data frame with specific columns
used in data processing: \code{dataschema_variable}, \code{input_dataset},
\code{input_variables}, \code{Mlstr_harmo::rule_category} and \code{Mlstr_harmo::algorithm}.
To initiate processing, the first entry must be the creation of a harmonized
primary identifier variable (e.g., participant unique ID).
}
\examples{
{

# Use Rmonize_DEMO to run examples.
library(dplyr)

glimpse(dataschema_extract(
  data_proc_elem = Rmonize_DEMO$`data_processing_elements - final`))
}

}
