\name{mixmodLearn}
\alias{mixmodLearn}
\alias{mixmodLearn.default}
\title{Create an instance of the [\code{\linkS4class{MixmodLearn}}] class}
\usage{
mixmodLearn(...)
\method{mixmodLearn}{default}(data, knownLabels, dataType = NULL,
    models = NULL, criterion = "CV", nbCVBlocks = 10,
    weight = NULL)
}
\arguments{
 \item{...}{The following arguments are accepted:}
  \item{data}{frame containing quantitative,qualitative or
  heterogeneous data. Rows correspond to observations and
  columns correspond to variables.}

  \item{knownLabels}{an integer vector or a factor of size
  number of observations. Each cell corresponds to a
  cluster affectation. So the maximum value is the number
  of clusters.}

  \item{dataType}{character. Type of data is
  "quantitative", "qualitative" or "composite". Set as NULL
  by default, type will be guessed depending on variables
  type (in case of homogeneous data). 'composite' type must
  be specified explicitly.}

  \item{models}{a [\code{\linkS4class{Model}}] object
  defining the list of models to run. For quantitative
  data, the model "Gaussian_pk_Lk_C" is called (see
  mixmodGaussianModel() to specify other models). For
  qualitative data, the model "Binary_pk_Ekjh" is called
  (see mixmodMultinomialModel() to specify other models).}

  \item{criterion}{list of character defining the criterion
  to select the best model. Possible values: "BIC", "CV" or
  c("CV","BIC"). Default is "CV".}

  \item{nbCVBlocks}{integer which defines the number of
  block to perform the Cross Validation. This value will be
  ignored if the CV criterion is not choosen. Default value
  is 10.}

  \item{weight}{numeric vector with n (number of
  individuals) rows. Weight is optionnal. This option is to
  be used when weight is associated to the data.}
}
\value{
  Returns an instance of the
  [\code{\linkS4class{MixmodLearn}}] class. Those two
  attributes will contain all outputs: \describe{
  \item{results}{a list of
  [\code{\linkS4class{MixmodResults}}] object containing
  all the results sorted in ascending order according to
  the given criterion.} \item{bestResult}{a S4
  [\code{\linkS4class{MixmodResults}}] object containing
  the best model results.} }
}
\description{
  This function computes the first step of a discriminant
  analysis. It will find the best classification rule by
  running an M step from the training observations.
}
\examples{
## A quantitative example with the famous iris data set
  learn.iris<-mixmodLearn(iris[1:4], iris$Species)
  ## get summary
  summary(learn.iris)

  ## A qualitative example with the famous birds data set
  data(birds)
  birds.partition<-as.integer(c(rep(1,34),rep(2,35)))
  learn.birds<-mixmodLearn(data=birds, knownLabels=birds.partition)
  ## get summary
  summary(learn.birds)

  ## A composite example with a heterogeneous data set
  data(heterodatatrain)
  learn.hetero<-mixmodLearn(heterodatatrain[-1],knownLabels=heterodatatrain$V1)
  ## get summary
  summary(learn.hetero)
}
\author{
  Florent Langrognet and Remi Lebret and Christian Poli and Serge Iovleff,
  with contributions from C. Biernacki and G. Celeux and G.
  Govaert \email{contact@mixmod.org}
}

