% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphFunctions.R
\name{event_line}
\alias{event_line}
\title{Create a Line Plot of Marine Heat Waves or Cold Spells.}
\usage{
event_line(data, min_duration = 5, spread = 150, metric = "int_cum",
  start_date = "1999-06-30", end_date = "2000-05-30")
}
\arguments{
\item{data}{The function receives the output from the \code{\link{detect}} function.}

\item{min_duration}{The minimum duration that an event has to for it to
qualify as a marine heat wave or marine cold spell.}

\item{spread}{The the number of days leading and trailing the largest event
(as per \code{metric}) detected within the time period specified by
\code{start_date} and \code{end_date}. The default is 150 days.}

\item{metric}{One of the following options: \code{int_mean}, \code{int_max}, \code{int_var},
\code{int_cum}, \code{int_mean_rel_thresh}, \code{int_max_rel_thresh}, \code{int_var_rel_thresh},
\code{int_cum_rel_thresh}, \code{int_mean_abs}, \code{int_max_abs}, \code{int_var_abs},
\code{int_cum_abs}, \code{int_mean_norm}, \code{int_max_norm}, \code{rate_onset}, \code{rate_decline}.
Partial name matching is currently not supported so please specify the metric
name precisely. The default is \code{int_cum}.}

\item{start_date}{The start date of a period of time within which the largest
event (as per \code{metric}) is retrieved and plotted. This may not necessarily
correspond to the biggest event of the specified metric within the entire
data set. To plot the biggest event within the whole time series, make sure
\code{start_date} and \code{end_date} straddle this event, or simply specify
the start and end dates of the full time series given to \code{\link{detect}}.}

\item{end_date}{The end date of a period of time within which the largest
event (as per \code{metric}) is retrieved and plotted. See \code{start_date}
for additional information.}
}
\value{
The function will return a line plot indicating the climatology,
threshold and temperature, with the hot or cold events that meet the
specifications of Hobday et al. (2016) shaded in as appropriate. The plotting
of hot or cold events depends on which option is specified in \code{\link{detect}}.
The top event detect during the selected time period will be visible in a
brighter colour. This function differs in use from \code{\link{geom_flame}}
in that it creates a stand alone figure. The benefit of this being
that one must not have any prior knowledge of ggplot2 to create the figure.
}
\description{
Creates a graph of warm or cold events as per the second row of Figure 3 in
Hobday et al. (2016).
}
\examples{
ts_dat <- make_whole(sst_WA)
res <- detect(ts_dat, climatology_start = 1983, climatology_end = 2012) # using default values

\dontrun{
event_line(res, spread = 200, metric = "int_cum",
start_date = "2010-10-01", end_date = "2011-08-30")
}
}
\references{
Hobday, A.J. et al. (2016), A hierarchical approach to defining
marine heatwaves, Progress in Oceanography, 141, pp. 227-238,
doi: 10.1016/j.pocean.2015.12.014
}
\author{
Robert W. Schlegel
}
