% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsolve_QMR.R
\name{lsolve.qmr}
\alias{lsolve.qmr}
\title{Quasi Minimal Residual Method}
\usage{
lsolve.qmr(A, B, xinit = NA, reltol = 1e-05, maxiter = 1000,
  preconditioner = diag(ncol(A)), verbose = TRUE)
}
\arguments{
\item{A}{an \code{(m-by-n)} dense or sparse matrix. See also \code{\link[Matrix]{sparseMatrix}}.}

\item{B}{a vector of length \code{m} or an \code{(m-by-k)} matrix (dense or sparse) for solving \code{k} systems simultaneously.}

\item{xinit}{a length-\code{n} vector for initial starting point. \code{NA} to start from a random initial point near 0.}

\item{reltol}{tolerance level for stopping iterations.}

\item{maxiter}{maximum number of iterations allowed.}

\item{preconditioner}{an \code{(n-by-n)} preconditioning matrix; default is an identity matrix.}

\item{verbose}{a logical; \code{TRUE} to show progress of computation.}
}
\value{
a named list containing \describe{
\item{x}{a solution of length \code{n}.}
\item{iter}{the number of iterations required.}
\item{errors}{a vector of errors for stopping criterion.}
}
}
\description{
Quasia-Minimal Resudial(QMR) method is another remedy of the BiCG which shows
rather irregular convergence behavior. It adapts to solve the reduced tridiagonal system
in a least squares sense and its convergence is known to be quite smoother than BiCG.
}
\examples{
## Overdetermined System
A = matrix(rnorm(10*5),nrow=10)
x = rnorm(5)
b = A\%*\%x

out1 = lsolve.cg(A,b)
out2 = lsolve.bicg(A,b)
out3 = lsolve.qmr(A,b)
matout = cbind(matrix(x),out1$x, out2$x, out3$x);
colnames(matout) = c("true x","CG result", "BiCG result", "QMR result")
print(matout)

}
\references{
Freund, R. and Nachtigal, N. (1991) \emph{QMR : A Quasi-Minimal Residual
Method for Non-Hermitian Linear Systems.} Numer. Math. Vol.60:315-339.
}
