/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.vm;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.URI;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.activemq.command.ShutdownInfo;
import org.apache.activemq.thread.DefaultThreadPools;
import org.apache.activemq.thread.Task;
import org.apache.activemq.thread.TaskRunner;
import org.apache.activemq.thread.Valve;
import org.apache.activemq.transport.FutureResponse;
import org.apache.activemq.transport.ResponseCallback;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportDisposedIOException;
import org.apache.activemq.transport.TransportListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VMTransport
implements Transport,
Task {
    private static final Object DISCONNECT = new Object();
    private static final AtomicLong NEXT_ID = new AtomicLong(0L);
    protected VMTransport peer;
    protected TransportListener transportListener;
    protected boolean disposed;
    protected boolean marshal;
    protected boolean network;
    protected boolean async = true;
    protected int asyncQueueDepth = 2000;
    protected LinkedBlockingQueue<Object> messageQueue;
    protected boolean started;
    protected final URI location;
    protected final long id;
    private TaskRunner taskRunner;
    private final Object lazyInitMutext = new Object();
    private final Valve enqueueValve = new Valve(true);
    private final AtomicBoolean stopping = new AtomicBoolean();
    private volatile int receiveCounter;

    public VMTransport(URI location) {
        this.location = location;
        this.id = NEXT_ID.getAndIncrement();
    }

    public void setPeer(VMTransport peer) {
        this.peer = peer;
    }

    @Override
    public void oneway(Object command) throws IOException {
        if (this.disposed) {
            throw new TransportDisposedIOException("Transport disposed.");
        }
        if (this.peer == null) {
            throw new IOException("Peer not connected.");
        }
        TransportListener transportListener = null;
        try {
            this.peer.enqueueValve.increment();
            if (this.peer.disposed || this.peer.stopping.get()) {
                throw new TransportDisposedIOException("Peer (" + this.peer.toString() + ") disposed.");
            }
            if (this.peer.started) {
                if (this.peer.async) {
                    this.peer.getMessageQueue().put(command);
                    this.peer.wakeup();
                } else {
                    transportListener = this.peer.transportListener;
                }
            } else {
                this.peer.getMessageQueue().put(command);
            }
        }
        catch (InterruptedException e) {
            InterruptedIOException iioe = new InterruptedIOException(e.getMessage());
            iioe.initCause(e);
            throw iioe;
        }
        finally {
            this.peer.enqueueValve.decrement();
        }
        this.dispatch(this.peer, transportListener, command);
    }

    public void dispatch(VMTransport transport, TransportListener transportListener, Object command) {
        if (transportListener != null) {
            if (command == DISCONNECT) {
                transportListener.onException(new TransportDisposedIOException("Peer (" + this.peer.toString() + ") disposed."));
            } else {
                ++transport.receiveCounter;
                transportListener.onCommand(command);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws Exception {
        if (this.transportListener == null) {
            throw new IOException("TransportListener not set.");
        }
        try {
            this.enqueueValve.turnOff();
            if (this.messageQueue != null && !this.async) {
                Object command;
                while ((command = this.messageQueue.poll()) != null && !this.stopping.get()) {
                    ++this.receiveCounter;
                    this.dispatch(this, this.transportListener, command);
                }
            }
            this.started = true;
            this.wakeup();
        }
        finally {
            this.enqueueValve.turnOn();
        }
        if (this.stopping.get()) {
            this.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws Exception {
        this.stopping.set(true);
        if (this.enqueueValve.isOn()) {
            try {
                this.peer.transportListener.onCommand(new ShutdownInfo());
            }
            catch (Exception ignore) {
                // empty catch block
            }
            TaskRunner tr = null;
            try {
                this.enqueueValve.turnOff();
                if (!this.disposed) {
                    this.started = false;
                    this.disposed = true;
                    if (this.taskRunner != null) {
                        tr = this.taskRunner;
                        this.taskRunner = null;
                    }
                }
            }
            finally {
                this.stopping.set(false);
                this.enqueueValve.turnOn();
            }
            if (tr != null) {
                tr.shutdown(1000L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean iterate() {
        TransportListener tl;
        try {
            this.enqueueValve.increment();
            tl = this.transportListener;
            if (!this.started || this.disposed || tl == null || this.stopping.get()) {
                if (this.stopping.get()) {
                    this.getMessageQueue().clear();
                }
                boolean bl = false;
                return bl;
            }
        }
        catch (InterruptedException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.enqueueValve.decrement();
        }
        LinkedBlockingQueue<Object> mq = this.getMessageQueue();
        Object command = mq.poll();
        if (command != null) {
            if (command == DISCONNECT) {
                tl.onException(new TransportDisposedIOException("Peer (" + this.peer.toString() + ") disposed."));
            } else {
                tl.onCommand(command);
            }
            return !mq.isEmpty();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTransportListener(TransportListener commandListener) {
        try {
            try {
                this.enqueueValve.turnOff();
                this.transportListener = commandListener;
                this.wakeup();
            }
            finally {
                this.enqueueValve.turnOn();
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LinkedBlockingQueue<Object> getMessageQueue() {
        Object object = this.lazyInitMutext;
        synchronized (object) {
            if (this.messageQueue == null) {
                this.messageQueue = new LinkedBlockingQueue(this.asyncQueueDepth);
            }
            return this.messageQueue;
        }
    }

    @Override
    public FutureResponse asyncRequest(Object command, ResponseCallback responseCallback) throws IOException {
        throw new AssertionError((Object)"Unsupported Method");
    }

    @Override
    public Object request(Object command) throws IOException {
        throw new AssertionError((Object)"Unsupported Method");
    }

    @Override
    public Object request(Object command, int timeout) throws IOException {
        throw new AssertionError((Object)"Unsupported Method");
    }

    @Override
    public TransportListener getTransportListener() {
        return this.transportListener;
    }

    @Override
    public <T> T narrow(Class<T> target) {
        if (target.isAssignableFrom(this.getClass())) {
            return target.cast(this);
        }
        return null;
    }

    public boolean isMarshal() {
        return this.marshal;
    }

    public void setMarshal(boolean marshal) {
        this.marshal = marshal;
    }

    public boolean isNetwork() {
        return this.network;
    }

    public void setNetwork(boolean network) {
        this.network = network;
    }

    public String toString() {
        return this.location + "#" + this.id;
    }

    @Override
    public String getRemoteAddress() {
        if (this.peer != null) {
            return this.peer.toString();
        }
        return null;
    }

    public boolean isAsync() {
        return this.async;
    }

    public void setAsync(boolean async) {
        this.async = async;
    }

    public int getAsyncQueueDepth() {
        return this.asyncQueueDepth;
    }

    public void setAsyncQueueDepth(int asyncQueueDepth) {
        this.asyncQueueDepth = asyncQueueDepth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void wakeup() {
        if (this.async) {
            Object object = this.lazyInitMutext;
            synchronized (object) {
                if (this.taskRunner == null) {
                    this.taskRunner = DefaultThreadPools.getDefaultTaskRunnerFactory().createTaskRunner(this, "VMTransport: " + this.toString());
                }
            }
            try {
                this.taskRunner.wakeup();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public boolean isFaultTolerant() {
        return false;
    }

    @Override
    public boolean isDisposed() {
        return this.disposed;
    }

    @Override
    public boolean isConnected() {
        return this.started;
    }

    @Override
    public void reconnect(URI uri) throws IOException {
        throw new IOException("Not supported");
    }

    @Override
    public boolean isReconnectSupported() {
        return false;
    }

    @Override
    public boolean isUpdateURIsSupported() {
        return false;
    }

    @Override
    public void updateURIs(boolean reblance, URI[] uris) throws IOException {
        throw new IOException("Not supported");
    }

    @Override
    public int getReceiveCounter() {
        return this.receiveCounter;
    }
}

