% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/france.R
\name{france}
\alias{france}
\title{france}
\usage{
france(
  site,
  variable = "discharge",
  start_date = NULL,
  end_date = NULL,
  sites = FALSE,
  ...
)
}
\arguments{
\item{site}{French gauge number}

\item{variable}{Character. Either \code{stage} or \code{discharge}.}

\item{start_date}{Character. Optional start date with format
YYYY-MM-DD. Default is 1900-01-01.}

\item{end_date}{Character. End date with format YYYY-MM-DD.
Default is the current date.}

\item{sites}{Logical. If TRUE, returns a list of measurement
sites.}

\item{...}{Additional arguments. None implemented.}
}
\value{
data frame of discharge time-series
}
\description{
Retrieve French gauge data
}
\examples{
\donttest{
df <- france('K027401001')
plot(df$Date, df$Q, type='l')
}
}
