% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrap12landmark.R
\name{wrap.landmark}
\alias{wrap.landmark}
\title{Wrap Landmark Data on Shape Space}
\usage{
wrap.landmark(input)
}
\arguments{
\item{input}{data matrices to be wrapped as \code{riemdata} class. Following inputs are considered,
\describe{
\item{array}{a \eqn{(k\times p\times n)} array where each slice along 3rd dimension is a \eqn{k}-ad in \eqn{\mathbf{R}^p}.}
\item{list}{a length-\eqn{n} list whose elements are \eqn{k}-ads.}
}}
}
\value{
a named \code{riemdata} S3 object containing
\describe{
  \item{data}{a list of preshapes in \eqn{\mathbf{R}^p}.}
  \item{size}{size of each preshape.}
  \item{name}{name of the manifold of interests, \emph{"landmark"}}
}
}
\description{
One of the frameworks used in shape space is to represent the data as landmarks. 
Each shape is a point set of \eqn{k} points in \eqn{\mathbf{R}^p} where each 
point is a labeled object. We consider general landmarks in \eqn{p=2,3,\ldots}. 
Note that when \eqn{p > 2}, it is stratified space but we assume singularities do not exist or 
are omitted. The wrapper takes translation and scaling out from the data to make it 
\emph{preshape} (centered, unit-norm). Also, for convenience, orthogonal 
Procrustes analysis is applied with the first observation being the reference so 
that all the other data are rotated to match the shape of the first.
}
\examples{
## USE 'GORILLA' DATA
data(gorilla)
riemobj = wrap.landmark(gorilla$male)

}
\references{
\insertRef{dryden_statistical_2016}{Riemann}
}
\concept{wrapper}
