% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Enrichment.R
\name{Enrichment}
\alias{Enrichment}
\title{Enrichment}
\usage{
Enrichment(Background, Genes2Dis = g2d$clean, Genes)
}
\arguments{
\item{Background}{The background list of genes. In generela is the list of genes expressed.}

\item{Genes2Dis}{A data.frame with the Gene names and the Diseases. The package has two inbuild lists. g2d_clean and g2d_complete. Both lists contains data from 4 publications (GS2D, DisGeNET, Berto2016 and PsyGeNET), however in the clean similar names were treated as the same disease.}

\item{Genes}{A list of genes to test for enrichment}
}
\value{
a list contating the enrichment of diseases
}
\description{
Given a list of genes associated to diseases and a background list, it calculates the diseases enrichment. It calculates both pvalues from proportion test and Fisher's exact test. Adjusted BH pvalues are returned.
}
\examples{
data('g2d')

g2d_clean = g2d$clean

# The user can choose a particular disorder, or use the whole disease set to compare to

g2d_ASD = subset(g2d_clean, g2d_clean$Disease \%in\% c('AUTISM'))
Enrichment(Background = g2d_clean$Gene.symbol,
Genes2Dis = g2d_ASD,
Genes = g2d_ASD$Gene.symbol[1:100])



}
\author{
Deisy Morselli Gysi <deisy at bioinf.uni-leipzig.de>
}
