% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search.R
\name{search_variant_annotation_sets}
\alias{search_variant_annotation_sets}
\title{Search for Variant Annotation Sets}
\usage{
search_variant_annotation_sets(client, variant_set_id, page_size = NULL,
  page_token = NULL)
}
\arguments{
\item{client}{A ga4gh_client object}

\item{variant_set_id}{The ID of the Variant Set to Search}

\item{page_size}{Specifies the maximum number of results to return in a single page.
If unspecified, the client default will be used.}

\item{page_token}{The continuation token, which is used to page through
large result sets. To get the next page of results, set this parameter to
the value of nextPageToken from the previous response.}
}
\description{
Search for Variant Annotation Sets
}
\examples{

ref_client <- ga4gh_client("http://1kgenomes.ga4gh.org", api_location = "")

\dontrun{
## Find a dataset to search in
datasets <- ref_client \%>\% search_datasets() \%>\% content
d_id <- datasets$datasets[[1]]$id

## Find a variant set to search in
variant_sets <- ref_client \%>\% search_variant_sets(d_id) \%>\% content()
vs_id <- variant_sets$variantSets[[2]]$id

## Search for variant annotation sets in the variant set
variant_annotation_sets <- ref_client \%>\%
 search_variant_annotation_sets(vs_id) \%>\% content()
variant_annotation_sets
}
}

