% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search.R
\name{search_references}
\alias{search_references}
\title{Search for References}
\usage{
search_references(client, reference_set_id = NULL, accession = NULL,
  md5checksum = NULL, page_size = NULL, page_token = NULL)
}
\arguments{
\item{client}{A ga4gh_client object}

\item{reference_set_id}{The ID of the Reference Set to search within}

\item{accession}{Return the References for which the accession matches this string (case-sensitive, exact match).}

\item{md5checksum}{Return the References for which the md5checksum matches this string (case-sensitive, exact match).}

\item{page_size}{Specifies the maximum number of results to return in a single page.
If unspecified, the client default will be used.}

\item{page_token}{The continuation token, which is used to page through
large result sets. To get the next page of results, set this parameter to
the value of nextPageToken from the previous response.}
}
\description{
Search for References
}
\examples{

ref_client <- ga4gh_client("http://1kgenomes.ga4gh.org", api_location = "")

\dontrun{
library(magrittr)
## Find a reference set to search in
reference_sets <- ref_client \%>\% search_reference_sets() \%>\% content()
rs_id <- reference_sets$referenceSets[[1]]$id

## Search for references in the reference set
references <- ref_client \%>\% search_references(rs_id) \%>\% content()
references
}
}

