% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search.R
\name{search_phenotypes}
\alias{search_phenotypes}
\title{Search for Phenotypes}
\usage{
search_phenotypes(client, phenotype_association_set_id = NULL,
  description = NULL, id = NULL, qualifiers = NULL, type = NULL,
  age_of_onset = NULL, page_size = NULL, page_token = NULL)
}
\arguments{
\item{client}{A ga4gh_client object}

\item{phenotype_association_set_id}{The ID of Phenotype Association Set to search within}

\item{description}{String}

\item{id}{String}

\item{qualifiers}{A data.frame with columns id, sourceName, sourceVersion, term.}

\item{type}{A named list with names id, sourceName, sourceVersion, term. Only return results that match this type}

\item{age_of_onset}{A named list with names id, sourceName, sourceVersion, term.
Only return results that match this age_of_onset}

\item{page_size}{Specifies the maximum number of results to return in a single page.
If unspecified, the client default will be used.}

\item{page_token}{The continuation token, which is used to page through
large result sets. To get the next page of results, set this parameter to
the value of nextPageToken from the previous response.}
}
\description{
Search for Phenotypes
}
\examples{

ref_client <- ga4gh_client("http://1kgenomes.ga4gh.org", api_location = "")

\dontrun{
library(magrittr)
## Find a dataset to search in
datasets <- ref_client \%>\% search_datasets() \%>\% content()
d_id <- datasets$datasets[[1]]$id

## Find a phenotype association set to search in
phenotype_association_sets <- ref_client \%>\%
 search_phenotype_association_sets(d_id) \%>\% content()
pas_id <- phenotype_association_sets$phenotypeAssociationSets[[1]]$id

## Search for pheotypes in the phenotype association set
phenotypes <- ref_client \%>\% search_phenotypes(pas_id) \%>\% content()
phenotypes$phenotypes[[1]]

}

}

