% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Request.R
\name{Request}
\alias{Request}
\title{Creates Request object}
\description{
Called internally for handling incoming requests from Rserve side.
Also useful for testing.
}
\examples{
# init simply request
rq = Request$new(
  path = "/",
  parameters_query = list(
    "param1" = "value1",
    "param2" = "value2"
  ),
  headers = list(
    "Content-encoding" = "identity",
    "Custom-field" = "value"
  ),
  cookies = list(
    "sessionId" = "1"
  )
)
# get request UUID
rq$id
# get content accept
rq$accept
# get request content type
rq$content_type
# get header by name (lower case)
rq$get_header("custom-field")
# get query param by name
rq$get_param_query("param1")
# print request
rq

}
\seealso{
\link{Response} \link{Application}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{path}}{Request path.}

\item{\code{method}}{Request HTTP method.}

\item{\code{headers}}{Request headers.}

\item{\code{cookies}}{Request cookies.}

\item{\code{context}}{Environment to store any data. Can be used in middlewares.}

\item{\code{content_type}}{Request body content type.}

\item{\code{body}}{Request body.}

\item{\code{parameters_query}}{Request query parameters.}

\item{\code{parameters_body}}{Request body parameters.}

\item{\code{parameters_path}}{List of parameters extracted from templated path
after routing. For example if we have some handler listening at
\verb{/job/\{job_id\}} and we are receiving request at \verb{/job/1} then
\code{parameters_path} will be \code{list(job_id = "1")}.\cr
It is important to understand that \code{parameters_path} will be available
(not empty) only after request will reach handler.\cr
This effectively means that \code{parameters_path} can be used inside handler
and response middleware (but not request middleware!).}

\item{\code{files}}{Structure which contains positions and lengths of files for
the multipart body.}

\item{\code{decode}}{Function to decode body for the specific content type.}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{id}}{Automatically generated UUID for each request. Read only.}

\item{\code{date}}{Request \code{Date} header converted to \code{POSIXct}.}

\item{\code{accept}}{Splitted \code{Accept} request header.}

\item{\code{accept_json}}{Request accepts JSON response.}

\item{\code{accept_xml}}{Request accepts XML response.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Request$new()}}
\item \href{#method-set_id}{\code{Request$set_id()}}
\item \href{#method-reset}{\code{Request$reset()}}
\item \href{#method-get_header}{\code{Request$get_header()}}
\item \href{#method-get_param_query}{\code{Request$get_param_query()}}
\item \href{#method-get_param_body}{\code{Request$get_param_body()}}
\item \href{#method-get_param_path}{\code{Request$get_param_path()}}
\item \href{#method-get_file}{\code{Request$get_file()}}
\item \href{#method-print}{\code{Request$print()}}
\item \href{#method-clone}{\code{Request$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates Request object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Request$new(
  path = "/",
  method = c("GET", "HEAD", "POST", "PUT", "DELETE", "CONNECT", "OPTIONS", "TRACE",
    "PATCH"),
  parameters_query = list(),
  parameters_body = list(),
  headers = list(),
  body = NULL,
  cookies = list(),
  content_type = NULL,
  decode = NULL,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{Character with requested path. Always starts with \code{/}.}

\item{\code{method}}{Request HTTP method.}

\item{\code{parameters_query}}{A named list with URL decoded query parameters.}

\item{\code{parameters_body}}{A named list with URL decoded body parameters.
This field is helpful when request is a urlencoded form or a multipart form.}

\item{\code{headers}}{Request HTTP headers represented as named list.}

\item{\code{body}}{Request body. Can be anything and in conjunction with
\code{content_type} defines how HTTP body will be represented.}

\item{\code{cookies}}{Cookies represented as named list. \strong{Note} that cookies
should be provided explicitly - they won't be derived from \code{headers}.}

\item{\code{content_type}}{HTTP content type. \strong{Note} that \code{content_type}
should be provided explicitly - it won't be derived from \code{headers}.}

\item{\code{decode}}{Function to decode body for the specific content type.}

\item{\code{...}}{Not used at this moment.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set_id"></a>}}
\if{latex}{\out{\hypertarget{method-set_id}{}}}
\subsection{Method \code{set_id()}}{
Set request id.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Request$set_id(id = uuid::UUIDgenerate(TRUE))}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{Request id.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-reset"></a>}}
\if{latex}{\out{\hypertarget{method-reset}{}}}
\subsection{Method \code{reset()}}{
Resets request object. This is not useful for end user, but useful for
RestRserve internals - resetting R6 class is much faster then initialize it.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Request$reset()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_header"></a>}}
\if{latex}{\out{\hypertarget{method-get_header}{}}}
\subsection{Method \code{get_header()}}{
Get HTTP response header value. If requested header is empty returns \code{default}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Request$get_header(name, default = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Header field name.}

\item{\code{default}}{Default value if header does not exists.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Header field values (character string).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_param_query"></a>}}
\if{latex}{\out{\hypertarget{method-get_param_query}{}}}
\subsection{Method \code{get_param_query()}}{
Get request query parameter by name.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Request$get_param_query(name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Query parameter name.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Query parameter value (character string).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_param_body"></a>}}
\if{latex}{\out{\hypertarget{method-get_param_body}{}}}
\subsection{Method \code{get_param_body()}}{
Get request body parameter by name.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Request$get_param_body(name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Body field name.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Body field value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_param_path"></a>}}
\if{latex}{\out{\hypertarget{method-get_param_path}{}}}
\subsection{Method \code{get_param_path()}}{
Get templated path parameter by name.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Request$get_param_path(name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Path parameter name.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Path parameter value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_file"></a>}}
\if{latex}{\out{\hypertarget{method-get_file}{}}}
\subsection{Method \code{get_file()}}{
Extract specific file from multipart body.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Request$get_file(name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Body file name.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Raw vector with \code{filname} and \code{content-type} attributes.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
Print method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Request$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Request$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
