% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setup.R
\name{useLinuxSourceCache}
\alias{useLinuxSourceCache}
\title{Use cache for R package compilation}
\usage{
useLinuxSourceCache(overwrite = FALSE)
}
\arguments{
\item{overwrite}{Logical. Should the existing configuration be overwritten?
For safety, a backup copy of the old configuration is created.}
}
\value{
Invoked for the side effect of copying files needed to configure \code{ccache} for R packages.
}
\description{
Simple \href{https://ccache.dev/}{\code{ccache}} configuration for compiling R packages on Linux,
based on \url{http://dirk.eddelbuettel.com/blog/2017/11/27/#011_faster_package_installation_one}.
}
\note{
This is typically run once per user, per machine to configure the cache.
}
\examples{
\dontrun{
 useLinuxSourceCache()
}
}
\author{
Dirk Eddelbuettel and Alex Chubaty
}
