% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/textProperties.R
\name{textProperties}
\alias{textProperties}
\alias{print.textProperties}
\alias{as.character.textProperties}
\alias{chprop.textProperties}
\title{Text formatting properties}
\usage{
textProperties(color = "black", font.size = getOption("ReporteRs-fontsize"),
  font.weight = "normal", font.style = "normal", underlined = FALSE,
  font.family = getOption("ReporteRs-default-font"),
  vertical.align = "baseline", shading.color)

\method{print}{textProperties}(x, ...)

\method{as.character}{textProperties}(x, ...)

\method{chprop}{textProperties}(object, color, font.size, font.weight,
  font.style, underlined, font.family, vertical.align, shading.color, ...)
}
\arguments{
\item{color}{font color - a single character value specifying
a valid color (e.g. "#000000" or "black").}

\item{font.size}{font size (in point) - 0 or positive integer value.}

\item{font.weight}{single character value specifying font weight
(expected value is \code{normal} or \code{bold}).}

\item{font.style}{single character value specifying font style
(expected value is \code{normal} or \code{italic}).}

\item{underlined}{single logical value specifying if the font is underlined.}

\item{font.family}{single character value specifying font name (it has to be
an existing font in the OS).}

\item{vertical.align}{single character value specifying font vertical alignments.
Expected value is one of the following : default \code{'baseline'}
or \code{'subscript'} or \code{'superscript'}}

\item{shading.color}{shading color - a single character value specifying
a valid color (e.g. "#000000" or "black").}

\item{x}{\code{textProperties} object to print}

\item{...}{further arguments - not used}

\item{object}{\code{textProperties} object to update}
}
\value{
a \code{textProperties} object
}
\description{
Create a \code{textProperties} object that describes
text formatting properties.
}
\details{
Get a modified version of a \code{textProperties} with
\code{chprop}.
}
\examples{
textProperties( font.size = 12 )
textProperties(color="red", font.weight = "bold",
  font.style = "italic", underlined = TRUE )
textProperties( shading.color = "red" )
print( textProperties (color="red", font.size = 12) )

# chprop usage example ------
textProp <- textProperties()

chprop( textProp, color = "red" )
chprop( textProp, font.size = 12 )
chprop( textProp, font.weight = "bold" )
chprop( textProp, font.style = "italic" )
chprop( textProp, underlined = TRUE )
chprop( textProp, font.family = "Arial" )
chprop( textProp, vertical.align = "superscript" )
chprop( textProp, font.size = 12,
        font.weight = "bold", shading.color = "red" )
}
\seealso{
\code{\link{pot}}, \code{\link{alterFlexTable}},
\code{\link{shortcut_properties}}
}

