% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addPageNumber.pptx.R
\name{addPageNumber.pptx}
\alias{addPageNumber.pptx}
\title{Insert a page number shape into a document pptx object}
\usage{
\method{addPageNumber}{pptx}(doc, value, ...)
}
\arguments{
\item{doc}{\code{\link{pptx}} object}

\item{value}{character value to add into the page number shape of the current slide.
optionnal. If missing current slide number will be used.}

\item{...}{further arguments, not used.}
}
\value{
a \code{\link{pptx}} document object
}
\description{
Insert a page number shape into the current slide of a \code{pptx} object.
}
\examples{
\donttest{
doc.filename <- "add_page_number_example.pptx"
doc <- pptx( title = "title" )
doc <- addSlide( doc, slide.layout = "Title Slide" )
# add a page number on the current slide ---
doc <- addPageNumber( doc )
doc <- addSlide( doc, slide.layout = "Title and Content" )
# add a page number with free text ----
doc <- addPageNumber( doc, value = "Page number text")
writeDoc( doc, file = doc.filename )
}
}
\seealso{
\code{\link{addPageNumber}}, \code{\link{addDate}}
}

