% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writeDoc.R
\name{writeDoc}
\alias{writeDoc}
\alias{writeDoc.bsdoc}
\alias{writeDoc.docx}
\alias{writeDoc.pptx}
\title{Write a document object}
\usage{
writeDoc(doc, ...)

\method{writeDoc}{docx}(doc, file, ...)

\method{writeDoc}{pptx}(doc, file, ...)

\method{writeDoc}{bsdoc}(doc, file, ...)
}
\arguments{
\item{doc}{document object}

\item{...}{unused}

\item{file}{single character value, name of the html file to write.}
}
\description{
Write a document object into a file
}
\details{
When the document object is a \code{\link{bsdoc}} object, \code{writeDoc} is
considering the directory where 'html' file is written. Bootstrap files (css, js, etc.)
will be copied in the directory if directory does not exist.
}
\examples{
doc <- docx()
writeDoc( doc, "ex_write_doc.docx")

doc <- pptx()
doc <- addSlide(doc, "Title and Content")
writeDoc( doc, "ex_write_doc.pptx")

doc <- bsdoc()
writeDoc( doc, "ex_write_doc/index.html")
}
\seealso{
\code{\link{docx}}, \code{\link{pptx}}, \code{\link{bsdoc}}
}

