% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chprop.FlexTable.R
\name{chprop.FlexTable}
\alias{chprop.FlexTable}
\title{format FlexTable}
\usage{
\method{chprop}{FlexTable}(object, value, i, j, to = "body", side = "top",
  ...)
}
\arguments{
\item{object}{the \code{FlexTable} object}

\item{value}{a formatting properties object (\code{textProperties}, \code{parProperties},
\code{borderProperties}, \code{cellProperties})}

\item{i}{vector (integer index, row.names values or boolean vector) for rows selection.}

\item{j}{vector (integer index, col.names values or boolean vector) for columns selection.}

\item{to}{specify on which part of the FlexTable to apply the \code{value}, must be one of the following
values \dQuote{body} (default) or \dQuote{header} or \dQuote{footer}}

\item{side}{used only when value is a \code{\link{borderProperties}}, specify on which side to
apply the properties. It must be one of \dQuote{bottom}, \dQuote{top}, \dQuote{left}, \dQuote{right}.}

\item{...}{unused}
}
\description{
Format a FlexTable object.
}
\examples{
my_ft <- vanilla.table( head( iris, n = 5 ) )
my_ft <- chprop( my_ft, textBoldItalic(), i = 1, to = "header" )
my_ft <- chprop( my_ft, parCenter(), j = 5 )
my_ft <- chprop( my_ft, borderSolid(color = "red"), i = 5, side = "bottom" )
}

