/*
 * Decompiled with CFR 0.152.
 */
package org.lysis.reporters.tables;

import java.util.LinkedHashMap;
import org.docx4j.dml.CTTableRow;
import org.docx4j.wml.Tr;
import org.lysis.reporters.tables.FlexCell;
import org.lysis.reporters.tools.HTML4R;

public class FlexRow
implements HTML4R {
    private LinkedHashMap<Integer, FlexCell> cellList = new LinkedHashMap();

    public void add(FlexCell fc) {
        this.cellList.put(this.size(), fc);
    }

    public void add(FlexCell fc, int i) {
        this.cellList.put(i, fc);
    }

    public int size() {
        return this.cellList.size();
    }

    public int weight() {
        int out = 0;
        if (this.size() > 0) {
            int i = 0;
            while (i < this.size()) {
                out += this.cellList.get(i).getColspan();
                ++i;
            }
        }
        return out;
    }

    public FlexCell getCell(int index) {
        return this.cellList.get(index);
    }

    public boolean hasCell(int index) {
        return this.cellList.containsKey(index);
    }

    public int getCellIDCellAt(int index) {
        int cell_id = 0;
        int colspan_curr = 0;
        while (true) {
            if (this.hasCell(cell_id)) {
                colspan_curr += this.getCell(cell_id).getColspan();
            }
            if (colspan_curr > index) break;
            ++cell_id;
        }
        return cell_id;
    }

    public boolean hasCellAt(int index) {
        int cell_id = 0;
        int colspan_curr = 0;
        while (true) {
            if (this.hasCell(cell_id)) {
                colspan_curr += this.getCell(cell_id).getColspan();
            }
            if (colspan_curr > index) {
                return true;
            }
            if (!this.hasCell(cell_id + 1)) {
                return false;
            }
            ++cell_id;
        }
    }

    public String toString() {
        String out = "";
        if (this.size() > 0) {
            int i = 0;
            while (i < this.size()) {
                out = String.valueOf(out) + this.cellList.get(i).toString();
                ++i;
            }
        }
        return out;
    }

    @Override
    public String getHTML() {
        String out = "<tr>";
        int i = 0;
        while (i < this.size()) {
            out = String.valueOf(out) + this.cellList.get(i).getHTML();
            ++i;
        }
        out = String.valueOf(out) + "</tr>";
        return out;
    }

    public Tr getTr() throws Exception {
        Tr workingRow = new Tr();
        int i = 0;
        while (i < this.size()) {
            workingRow.getContent().add(this.cellList.get(i).getTc());
            ++i;
        }
        return workingRow;
    }

    public CTTableRow getCTTableRow() throws Exception {
        CTTableRow workingRow = new CTTableRow();
        int i = 0;
        while (i < this.size()) {
            FlexCell temp = this.cellList.get(i);
            workingRow.getTc().add(temp.getCTTableCell());
            if (temp.getColspan() > 1) {
                int p = 1;
                while (p < temp.getColspan()) {
                    FlexCell temp1 = temp.clone();
                    temp1.setColspan(0);
                    workingRow.getTc().add(temp1.getCTTableCell());
                    ++p;
                }
            }
            ++i;
        }
        return workingRow;
    }

    @Override
    public String getCSS() {
        return "";
    }

    @Override
    public String getJS() {
        return "";
    }

    @Override
    public boolean hasJS() {
        return false;
    }

    @Override
    public boolean hasHTML() {
        return true;
    }

    @Override
    public boolean hasCSS() {
        return false;
    }
}

