## ----eval=FALSE, prompt=FALSE--------------------------------------------
#  env(X, Y, u, asy = TRUE, init = NULL)

## ----eval=FALSE, prompt=FALSE--------------------------------------------
#  u.env(X, Y, alpha = 0.01)

## ----eval=FALSE, prompt=FALSE--------------------------------------------
#  boot.env(X, Y, u, B)

## ----eval=FALSE, prompt=FALSE--------------------------------------------
#  pred.env(m, Xnew)

## ----eval=FALSE, prompt=FALSE--------------------------------------------
#  cv.env(X, Y, u, m, nperm)

## ----eval=FALSE, prompt=FALSE--------------------------------------------
#  testcoef.env(m, L, R, A)

## ------------------------------------------------------------------------
library("Renvlp")
data("Berkeley")
X <- Berkeley[ , 1]
Y <- Berkeley[ , c(22, 24)]
u <- u.env(X, Y)
u

## ------------------------------------------------------------------------
m <- env(X, Y, 1)
m$beta
m$Gamma
m$Gamma0

## ------------------------------------------------------------------------
m2 <- env(X, Y, 2)
m2$beta

## ------------------------------------------------------------------------
m$asySE / sqrt(93)
m2$asySE / sqrt(93)

## ------------------------------------------------------------------------
bootse1 <- boot.env(X, Y, 1, 200)
bootse2 <- boot.env(X, Y, 2, 200)
bootse1
bootse2

## ------------------------------------------------------------------------
L <- matrix(c(1, 0), 1, 2)
R <- as.matrix(1)
A <- as.matrix(0)
hres <- testcoef.env(m, L, R, A)
hres2 <- testcoef.env(m2, L, R, A)
hres
hres2

## ------------------------------------------------------------------------
pres <- pred.env(m, 1)
pres

