% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/experienceReplay.R
\name{replayExperience}
\alias{replayExperience}
\title{Performs experience replay}
\usage{
replayExperience(D, Q, control, ...)
}
\arguments{
\item{D}{A \code{dataframe} containing the input data for reinforcement learning.
Each row represents a state transition tuple \code{(s,a,r,s_new)}.}

\item{Q}{Existing state-action table of type \code{hash}.}

\item{control}{Control parameters defining the behavior of the agent.}

\item{...}{Additional parameters passed to function.}
}
\value{
Returns an object of class \code{hash} that contains the learned Q-table.
}
\description{
Performs experience replay. Experience replay allows reinforcement learning agents to remember and reuse experiences from the past.
The algorithm requires input data in the form of sample sequences consisting of states, actions and rewards.
The result of the learning process is a state-action table Q that allows one to infer the best possible action in each state.
}
\references{
Lin (1992). "Self-Improving Reactive Agents Based on Reinforcement Learning, Planning and Teaching", Machine Learning (8:3), pp. 293--321.

Watkins (1992). "Q-learning". Machine Learning (8:3), pp. 279--292.
}
\seealso{
\code{\link{ReinforcementLearning}}
}
