% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TuckerCoef.R
\name{TuckerCoef}
\alias{TuckerCoef}
\title{Tucker coefficient of congruence.}
\usage{
TuckerCoef(MatrixA, MatrixB)
}
\arguments{
\item{MatrixA}{A matrix}

\item{MatrixB}{A matrix, which is to be compared to MatrixA}
}
\value{
\item{perm}{the permutation order.}
\item{tucker_value}{the Tucker coefficient.}
\item{tucker_vector}{the Tucker vector.}
}
\description{
\code{TuckerCoef} calculate Tucker's coefficient of congruence between columns but after accounting for permutational freedom and reflections
}
\examples{
\dontrun{
maxtrix1 <- matrix(rnorm(50), nrow=5)
maxtrix2 <- matrix(rnorm(50), nrow=5)
TuckerCoef(maxtrix1, maxtrix2)
}
}
\references{
Lorenzo-Seva, U., & Ten Berge, J. M. (2006). Tucker's congruence coefficient as a meaningful index of factor similarity. \emph{Methodology}, \emph{2}(2), 57-64.
}
