% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getMutexAB.R
\name{getMutexAB}
\alias{getMutexAB}
\title{getMutexAB function}
\usage{
getMutexAB(
  A,
  PMA = getPM(A),
  B,
  PMB = getPM(B),
  lower.tail = TRUE,
  method = "ShiftedBinomial",
  mixed = TRUE,
  th = 0.05,
  verbose = FALSE,
  parallel = FALSE,
  no_cores = NULL
)
}
\arguments{
\item{A}{The binary matrix of events A}

\item{PMA}{The corresponding probability matrix of A. It can be computed using function getPM. By default equal to getPM(A)}

\item{B}{The binary matrix of events B}

\item{PMB}{The corresponding probability matrix of B. It can be computed using function getPM. By default equal to getPM(B)}

\item{lower.tail}{True if mutually exclusive test. False for co-ocurrence. By default is TRUE.}

\item{method}{one of the following: "ShiftedBinomial" (default),"Exact", "RefinedNormal", and "Binomial".}

\item{mixed}{option to compute lower p-values with an exact method. By default TRUE}

\item{th}{upper threshold of p-value to apply the exact method.}

\item{verbose}{The verbosity of the output}

\item{parallel}{If the exact method is executed with a parallel process.}

\item{no_cores}{number of cores. If not stated number of cores of the CPU - 1}
}
\value{
A  matrix with the p-values of the corresponding test.
}
\description{
Given two binary matrices and its corresponding probability matrices PAij and PBij, compute the Poisson Binomial
method to estimate mutual exclusive events between A and B
}
\details{
we  implemented three different approximations of the Poison-Binomial distribution function:
\itemize{
 \item "ShiftedBinomial" (by default) that correspond to a shifted Binomial with three parameters (Peköz, Shwartz, Christiansen, & Berlowitz, 2010).
 \item"Exact" that use the exact formula using the `PoissonBinomial` Rpackage based on the work from (Biscarri, Zhao, & Brunner, 2018).
 \item"Binomial" with two parameters (Cam, 1960).
 \item"RefinedNormal" that is based on the work from  (Volkova, 1996).
}
 If `mixed` option is selected (by default is FALSE), the "Exact" method is computed for p-values lower than a threshold
  (`th` parameter, that by default is 0.05). When the exact method is computed, it is possible to parallelize the process by
  selecting the option `parallel` (by default FALSE) and setting the number of cores (`no_cores` parameter)
}
\examples{

  \donttest{   
  
  #The next example, is the same as the first
  # one but, using a matrix of class Matrix. 
  
  data("A_Matrix")
  data("B_Matrix")
  PMA <- getPM(A_Matrix)
  PMB <- getPM(B_Matrix)
  mismutex <- getMutexAB(A=A_Matrix, PM=PMA, B=B_Matrix, PMB = PMB)
  
  #Finally, the last example, shows a 
  #real example of how to perform this function
  # when using data from TCGA, Colon Adenocarcinoma in this case. 
  
  \dontrun{
  data("TCGA_COAD_AMP")
  data("AMP_COAD")
  data("PM_TCGA_COAD_AMP")
  data("PM_AMP_COAD")
  
  mismutex <- getMutexAB(A=TCGA_COAD_AMP, 
                         PMA=PM_TCGA_COAD_AMP,
                         B=AMP_COAD,
                         PMB = PM_AMP_COAD)
   }
 }

}
