% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getPM.R
\name{getPM}
\alias{getPM}
\title{getPM function}
\usage{
getPM(A)
}
\arguments{
\item{A}{The binary matrix}
}
\value{
A `PMatrix` object with the corresponding probability estimations.
This `PMatrix` object stored the corresponding coefficients of the 
logistic regression computed. With this coefficients it is possible to build
the complete matrix of probabilities.
}
\description{
Given a binary matrix estimates the corresponding probability  matrix pij.
}
\examples{


  #This first example is a basic example of how to perform getPM: 
  
  data("A_example")
  PMA <- getPM(A_example)
  
  #The next example, is the same as the first one but, 
  #using a matrix of class Matrix: 
  
  data("A_Matrix")
  PMA_Matrix <- getPM(A_Matrix)
  
  #Finally, the last example, shows a real example 
  #of how to perform this function when when using
  #data from TCGA, Colon Adenocarcinoma in this case: 
  data("TCGA_COAD")
  PM_COAD <- getPM(TCGA_COAD)


}
