% Generated by roxygen2 (4.1.1.9000): do not edit by hand
% Please edit documentation in R/RedditExtractoR.R
\name{GetReddit}
\alias{GetReddit}
\title{Get all data attributes from search query (wrapper for a combination of ObtainRedditURLs and ExtractAttributes functions)}
\usage{
GetReddit(search_terms, regex_filter = "", cn_threshold = 50,
  page_threshold = 1, wait_time = 2)
}
\arguments{
\item{search_terms}{A string of terms to be searched on Reddit}

\item{regex_filter}{An optional regular expression filter that will remove URLs with titles that do not match the condition.}

\item{cn_threshold}{Comment number threshold that remove URLs with fewer comments that cn_threshold. 10 by default.}

\item{page_threshold}{Page threshold that controls the number of pages is going to be searched for a given search word. 100 by default.}

\item{wait_time}{wait time in seconds between page requests. 2 by default and it is also the minimum (API rate limit).}
}
\value{
A data frame with post / thread date (post_date), comment date (comm_date), number of comments within a post / thread (num_comments), subreddit (subreddit)
upvote proportion (upvote_prop), post /thread score (post_score), author of the post / thread (author), user corresponding to the comment (user),
comment score (comment_score), controversiality (controversiality), comment (comment), title (title), post / thread text (post_text), URL referenced (link)
domain of the references URL (domain)
}
\description{
Get all data attributes from search query (wrapper for a combination of ObtainRedditURLs and ExtractAttributes functions)
}
\examples{
\dontrun{
example_data = GetReddit(search_terms="economy")
}
}

