% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R.record.R
\name{R.record}
\alias{R.record}
\title{Record Values}
\usage{
R.record(X, record = c("upper", "lower"), weak = FALSE)
}
\arguments{
\item{X}{A numeric vector, matrix (or data frame).}

\item{record}{A character string indicating the type of record to be 
calculated, "upper" or "lower".}

\item{weak}{Logical. If \code{TRUE}, weak records are also counted. Default
to \code{FALSE}.}
}
\value{
If \code{X} is a vector, the function returns a column matrix 
  containing the record values. If \code{X} is a matrix, the function 
  returns a list where each element is a vector indicating the record values 
  of the corresponding \code{X} column.
}
\description{
Returns the record values of the values in a vector.
  A record value is the magnitude of a record observation. 
  
  If the argument \code{X} is a matrix, then each column is treated as a 
  different vector.
}
\details{
The sequence of record values \eqn{\{R_1,\ldots,R_I\}} can be 
  expressed in terms of the record times 
  \code{\link{L.record}} by
  \deqn{R_i = X_{L_i}.}
  
  Record values can be calculated for both upper and lower records.
}
\examples{
Y1 <- c( 1,  5,  3,  6,  6,  9,  2)
Y2 <- c(10,  5,  3,  6,  6,  9,  2)
Y3 <- c( 5,  7,  3,  6, 19,  2, 20)
Y  <- cbind(Y1, Y2, Y3)

R.record(Y1)
R.record(Y)

}
\references{
Arnold BC, Balakrishnan N, Nagaraja HN (1998). 
\emph{Records}. 
Wiley Series in Probability and Statistics. Wiley, New York.
}
\seealso{
\code{\link{I.record}}, \code{\link{L.record}}, 
  \code{\link{N.record}}, \code{\link{Nmean.record}}, 
  \code{\link{p.record}}, \code{\link{R.record}}, 
  \code{\link{records}}, \code{\link{S.record}}
}
\author{
Jorge Castillo-Mateo
}
