% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/series_uncor.R
\name{series_uncor}
\alias{series_uncor}
\title{Extracts a subset of uncorrelated vectors}
\usage{
series_uncor(XM_T, m = 1, alpha = 0.05)
}
\arguments{
\item{XM_T}{A numeric matrix (or data frame) where the uncorrelated vectors 
are extracted from.}

\item{m}{Integer value giving the starting column.}

\item{alpha}{Numeric value in \eqn{(0,1)}. It gives the significance level 
of the correlation test where alternative hypothesis is that the true 
correlation is not equal to 0.}
}
\value{
A vector with the index of the uncorrelated columns in the matrix.
}
\description{
Given a set of \eqn{M} vectors, this function extracts 
  a subset of them which are uncorrelated.
}
\details{
This function is used in the data preparation (or pre-processing) 
  often required to apply the record inference tools in this package.

  Given a set of \eqn{M} vectors, which are the columns of matrix 
  \code{XM_T}, this function extracts the biggest subset of uncorrelated 
  vectors (columns),  using the following procedure: starting from column 
  \code{m}, the test \code{\link{cor.test}} is applied to study the 
  correlation between columns \code{m} and 
  \eqn{\code{m} + 1, \code{m} + 2, \ldots} an so on up to find a column 
  \eqn{\code{m} + k} which is not significantly correlated with column 
  \code{m}. Then, the process is repeated starting at column 
  \eqn{\code{m} + k}.
}
\examples{
ZM_T <- series_split(TX_Zaragoza$TX)

series_uncor(ZM_T)

}
\seealso{
\code{\link{series_double}}, \code{\link{series_rev}}, 
  \code{\link{series_split}}, \code{\link{series_untie}}
}
\author{
Jorge Castillo-Mateo
}
