% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RelTableModel.R
\name{RelTableModel}
\alias{RelTableModel}
\title{Create a RelTableModel object}
\usage{
RelTableModel(l)
}
\arguments{
\item{l}{the list with the following elements
\itemize{
\item \strong{tableName}: a character vector of length one
\item \strong{fields}: a tibble with the follwoing columns:
\itemize{
\item \emph{name}: character
\item \emph{type}: character
\item \emph{nullable}: logical
\item \emph{comment}:  character
}
\item \strong{primaryKey}: a character vector of any length. All
values should be in fields$name
\item \strong{foreignKeys}: a list of foreign keys. Each foreigned key is defined
as a list with the following elements:
\itemize{
\item \emph{refTable}: a character vector of length one (the referenced table)
\item \emph{key}: a tibble with a "from" and a "to" columns
\item (\emph{cardinality}): an optional integer vector with 4 values:
\itemize{
\item fmin: from minimum cardinality
\item fmax: from maximum cardinality
\item tmin: to minimum cardinality
\item tmax: to maximum cardinality
}
}
\item \strong{indexes}: a list of indexes. Each index is defined by
3 columns:
\itemize{
\item \emph{field}: character (all in fields$name)
\item \emph{order}: character
\item \emph{unique}: logical
}
\item \strong{display}: a list gathering:
\itemize{
\item \emph{x}: single numeric value for the x position of the table
\item \emph{y}: single numeric value for the y position of the table
\item \emph{color}: single character value corresponding to the color of the table
\item \emph{comment}: single character value with some description of the table
}
}}
}
\value{
A RelTableModel object.
}
\description{
Create a RelTableModel object
}
