/*
 * Decompiled with CFR 0.152.
 */
package org.math.r.drools;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.CSVRecord;
import org.drools.core.SessionConfiguration;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.Message;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;

public class DroolsService {
    private String[] inputColumns = null;
    private List<String> expectedInputColumns = null;
    private List<String> outputColumns = null;
    private KieServices kService = KieServices.Factory.get();
    private KieSession session;

    public DroolsService(String rules, String expectedInputColumnsCSV, String outputColumnsCSV) throws Exception {
        this.expectedInputColumns = new ArrayList<String>();
        this.outputColumns = new ArrayList<String>();
        this.validateInputs(rules, expectedInputColumnsCSV, this.expectedInputColumns, outputColumnsCSV, this.outputColumns);
        this.session = this.createSession(rules);
    }

    public String execute(String inputCSV) throws Exception {
        String outputCSV = null;
        this.validateInputCSV(inputCSV);
        CSVParser parser = new CSVParser((Reader)new StringReader(inputCSV), CSVFormat.DEFAULT.withHeader(new String[0]));
        Set header = parser.getHeaderMap().keySet();
        this.inputColumns = header.toArray(new String[header.size()]);
        this.verifyInputColumns(this.expectedInputColumns, this.inputColumns);
        ByteArrayOutputStream csvOutputStream = new ByteArrayOutputStream();
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter(csvOutputStream));
        CSVPrinter printer = new CSVPrinter((Appendable)out, CSVFormat.DEFAULT.withRecordSeparator('\n'));
        printer.printRecord(this.outputColumns);
        this.runRules(this.inputColumns, this.outputColumns, parser, printer, this.session);
        printer.flush();
        outputCSV = new String(csvOutputStream.toByteArray(), "UTF-8");
        parser.close();
        printer.close();
        return outputCSV;
    }

    protected void validateInputCSV(String inputCSV) throws Exception {
        if (inputCSV == null || inputCSV == "") {
            throw new IllegalArgumentException("The input dataset is emtpy!");
        }
    }

    protected void validateInputs(String rules, String expectedInputColumnsCSV, List<String> expectedInputColumns, String outputColumnsCSV, List<String> outputColumns) throws Exception {
        if (rules == null || rules == "") {
            throw new IllegalArgumentException("Empty rules file!");
        }
        StringTokenizer tokenizer = null;
        if (expectedInputColumnsCSV != null && expectedInputColumnsCSV != "") {
            tokenizer = new StringTokenizer(expectedInputColumnsCSV.replace(" ", ""), ",");
            while (tokenizer.hasMoreTokens()) {
                expectedInputColumns.add(tokenizer.nextToken());
            }
        } else {
            throw new IllegalArgumentException("No input columns found!");
        }
        if (expectedInputColumnsCSV != null && expectedInputColumnsCSV != "") {
            tokenizer = new StringTokenizer(outputColumnsCSV.replace(" ", ""), ",");
            while (tokenizer.hasMoreTokens()) {
                outputColumns.add(tokenizer.nextToken());
            }
        } else {
            throw new IllegalArgumentException("No output columns found!");
        }
    }

    protected void verifyInputColumns(List<String> expectedInputColumns, String[] inputColumns) throws Exception {
        for (String column : expectedInputColumns) {
            boolean found = false;
            for (int index = 0; index < inputColumns.length; ++index) {
                if (!inputColumns[index].equals(column)) continue;
                found = true;
                break;
            }
            if (found) continue;
            throw new IllegalArgumentException("Error: The input CSV file does not contain the column '" + column + "' which is required by the rules file!");
        }
    }

    protected KieSession createSession(String rules) throws IllegalArgumentException {
        KieFileSystem kfs = this.kService.newKieFileSystem();
        kfs.write("/src/main/resources/rule.drl", this.kService.getResources().newReaderResource((Reader)new StringReader(rules)));
        KieBuilder builder = this.kService.newKieBuilder(kfs).buildAll();
        if (builder.getResults().hasMessages(new Message.Level[]{Message.Level.ERROR})) {
            throw new IllegalArgumentException("Error parsing rules file: " + builder.getResults().toString());
        }
        KieContainer kContainer = this.kService.newKieContainer(this.kService.getRepository().getDefaultReleaseId());
        SessionConfiguration kConf = SessionConfiguration.getDefaultInstance();
        this.session = kContainer.newKieSession((KieSessionConfiguration)kConf);
        return this.session;
    }

    protected void runRules(String[] inputColumns, List<String> outputColumns, CSVParser parser, CSVPrinter printer, KieSession session) throws Exception {
        ArrayList outputRow = new ArrayList(outputColumns.size());
        Iterator iterator = parser.iterator();
        HashMap outputMap = new HashMap();
        session.setGlobal("output", outputMap);
        while (iterator.hasNext()) {
            int index;
            CSVRecord inputRow = (CSVRecord)iterator.next();
            HashMap<String, String> inputMap = new HashMap<String, String>();
            for (index = 0; index < inputColumns.length; ++index) {
                inputMap.put(inputColumns[index], inputRow.get(index));
            }
            if (outputMap.size() > 0) {
                outputMap.clear();
            }
            session.insert(inputMap);
            session.fireAllRules();
            if (outputMap.size() <= 0) continue;
            for (index = 0; index < outputColumns.size(); ++index) {
                outputRow.add(index, outputMap.get(outputColumns.get(index)));
            }
            printer.printRecord(outputRow);
            outputRow.clear();
        }
    }
}

