% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EDR.R
\name{EDR}
\alias{EDR}
\title{Effective Detection Radius (EDR) for estimated detection functions
  with point transects}
\usage{
EDR(obj, newdata)
}
\arguments{
\item{obj}{An estimated detection function object.  An estimated detection 
function object has class 'dfunc', and is usually produced by a call to 
\code{dfuncEstim}. The estimated detection function may optionally contain 
a \eqn{g(0)} component.  If no \eqn{g(0)} component is found, \eqn{g(0)} =
1 is assumed.}

\item{newdata}{A data frame containing new values of the covariates at which
EDR's are sought. If NULL or missing and 
\code{obj} contains covariates, the covariates stored in \code{obj}
are used.  See \bold{Value} section.}
}
\value{
If \code{newdata} is not missing and not NULL and 
covariates are present in \code{obj}, returned value is 
a vector with length equal to the number of rows in \code{newdata}. 
If \code{newdata} is missing or NULL and covariates are present
in \code{obj}, returned value is a vector with length equal to 
the number of detections in \code{obj$detections}. In either of the 
above cases, elements in the returned vector are 
the effective detection radii for the corresponding set of 
covariates.  

If \code{obj} does not contain covariates, \code{newdata} is ignored and 
a scalar equal to the (constant) effective detection radius for all 
detections is returned.
}
\description{
Computes Effective Detection Radius (EDR) for estimated 
  detection functions with point transects.  The point-transect equivalent to
  Effective Strip Width (ESW).
}
\details{
The point-transect equivalent to Effective Strip Width (ESW).
}
\examples{
# Load example thrasher data (point transect survey type)
data(thrasherDetectionData)

# Fit half-normal detection function
dfunc <- dfuncEstim(formula=dist~1
                  , detectionData=thrasherDetectionData
                  , likelihood="halfnorm"
                  , w.hi=units::set_units(175, "m")
                  , pointSurvey=TRUE)

# Compute effective detection radius (EDR)
EDR(dfunc)

# EDR only applies to point transect surveys
# ESW is the line transect equivalent
# The effectiveDistance function tests whether the dfunc was
# fit to line or point data, and returns either ESW or EDR accordingly
effectiveDistance(dfunc)
  
}
\seealso{
\code{\link{dfuncEstim}}, \code{\link{ESW}}, 
\code{\link{effectiveDistance}}
}
\keyword{modeling}
