% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nonlinear_KMFA.R
\name{do.kmfa}
\alias{do.kmfa}
\title{Kernel Marginal Fisher Analysis}
\usage{
do.kmfa(
  X,
  label,
  ndim = 2,
  preprocess = c("center", "scale", "cscale", "decorrelate", "whiten"),
  k1 = max(ceiling(nrow(X)/10), 2),
  k2 = max(ceiling(nrow(X)/10), 2),
  t = 1
)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations.}

\item{label}{a length-\eqn{n} vector of data class labels.}

\item{ndim}{an integer-valued target dimension.}

\item{preprocess}{an additional option for preprocessing the data.
Default is "center". See also \code{\link{aux.preprocess}} for more details.}

\item{k1}{the number of same-class neighboring points (homogeneous neighbors).}

\item{k2}{the number of different-class neighboring points (heterogeneous neighbors).}

\item{t}{bandwidth parameter for heat kernel in \eqn{(0,\infty)}.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
}
}
\description{
Kernel Marginal Fisher Analysis (KMFA) is a nonlinear variant of MFA using kernel tricks.
For simplicity, we only enabled a heat kernel of a form
\deqn{k(x_i,x_j)=\exp(-d(x_i,x_j)^2/2*t^2)}
where \eqn{t} is a bandwidth parameter. Note that the method is far sensitive to the choice of \eqn{t}.
}
\examples{
## generate data of 3 types with clear difference
set.seed(100)
dt1  = aux.gensamples(n=20)-100
dt2  = aux.gensamples(n=20)
dt3  = aux.gensamples(n=20)+100

## merge the data and create a label correspondingly
X      = rbind(dt1,dt2,dt3)
label  = rep(1:3, each=20)

## try different numbers for neighborhood size
out1 = do.kmfa(X, label, k1=10, k2=10, t=0.001)
out2 = do.kmfa(X, label, k1=10, k2=10, t=0.01)
out3 = do.kmfa(X, label, k1=10, k2=10, t=0.1)

## visualize
opar = par(no.readonly=TRUE)
par(mfrow=c(1,3))
plot(out1$Y, pch=19, col=label, main="bandwidth=0.001")
plot(out2$Y, pch=19, col=label, main="bandwidth=0.01")
plot(out3$Y, pch=19, col=label, main="bandwidth=0.1")
par(opar)

}
\references{
\insertRef{yan_graph_2007}{Rdimtools}
}
\author{
Kisung You
}
\concept{nonlinear_methods}
