% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_SPECU.R
\name{do.specu}
\alias{do.specu}
\title{Unsupervised Spectral Feature Selection}
\usage{
do.specu(
  X,
  ndim = 2,
  sigma = 1,
  ranking = c("method1", "method2", "method3"),
  preprocess = c("null", "center", "scale", "cscale", "whiten", "decorrelate")
)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations
and columns represent independent variables.}

\item{ndim}{an integer-valued target dimension.}

\item{sigma}{bandwidth parameter for RBK kernel of type \eqn{S_{i,j} = \exp(-\|x_i - x_j \|^2 / 2\sigma^2 )}.}

\item{ranking}{types of feature scoring method. See the paper in the reference for more details.}

\item{preprocess}{an additional option for preprocessing the data. Default is "null". See also \code{\link{aux.preprocess}} for more details.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{sscore}{a length-\eqn{p} vector of spectral feature scores.}
\item{featidx}{a length-\eqn{ndim} vector of indices with highest scores.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
\item{projection}{a \eqn{(p\times ndim)} whose columns are basis for projection.}
}
}
\description{
SPEC algorithm selects features from the data via spectral graph approach.
Three types of ranking methods that appeared in the paper are available where
the graph laplacian is built via RBF kernel.
}
\examples{
\donttest{
## use iris data
## it is known that feature 3 and 4 are more important.
data(iris)
set.seed(100)
subid    = sample(1:150,50)
iris.dat = as.matrix(iris[subid,1:4])
iris.lab = as.factor(iris[subid,5])


## try different ranking methods
mysig = 6
out1  = do.specu(iris.dat, sigma=mysig, ranking="method1")
out2  = do.specu(iris.dat, sigma=mysig, ranking="method2")
out3  = do.specu(iris.dat, sigma=mysig, ranking="method3")

## visualize
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,3))
plot(out1$Y, pch=19, col=iris.lab, main="SPECU::method1")
plot(out2$Y, pch=19, col=iris.lab, main="SPECU::method2")
plot(out3$Y, pch=19, col=iris.lab, main="SPECU::method3")
par(opar)
}

}
\references{
\insertRef{zhao_spectral_2007}{Rdimtools}
}
\seealso{
\code{\link{do.specs}}
}
\author{
Kisung You
}
\concept{linear_methods}
