% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_danco.R
\name{est.danco}
\alias{est.danco}
\title{Intrinsic Dimensionality Estimation with DANCo}
\usage{
est.danco(X, k = 5)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations.}

\item{k}{the neighborhood size used for estimating local intrinsic dimension.}
}
\value{
a named list containing containing \describe{
\item{estdim}{estimated dimension via the method.}
}
}
\description{
DANCo exploits the balanced information of both the normalized nearest neighbor distances
as well as the angles of data pairs in the neighboring points.
}
\examples{
\donttest{
## create 3 datasets of intrinsic dimension 2.
X1 = aux.gensamples(dname="swiss")
X2 = aux.gensamples(dname="ribbon")
X3 = aux.gensamples(dname="saddle")

## acquire an estimate for intrinsic dimension
out1 = est.danco(X1, k=10)
out2 = est.danco(X2, k=10)
out3 = est.danco(X3, k=10)

## print the results
sprintf("* est.danco : estimated dimension for 'swiss'  data is \%.2f.",out1$estdim)
sprintf("* est.danco : estimated dimension for 'ribbon' data is \%.2f.",out2$estdim)
sprintf("* est.danco : estimated dimension for 'saddle' data is \%.2f.",out3$estdim)
}

}
\references{
\insertRef{ceruti_danco_2014}{Rdimtools}
}
