% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nonlinear_BMDS.R
\name{do.bmds}
\alias{do.bmds}
\title{Bayesian Multidimensional Scaling}
\usage{
do.bmds(
  X,
  ndim = 2,
  par.a = 5,
  par.alpha = 0.5,
  par.step = 1,
  mc.iter = 8128,
  preprocess = c("null", "center", "scale", "cscale", "whiten", "decorrelate"),
  print.progress = TRUE
)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations.}

\item{ndim}{an integer-valued target dimension.}

\item{par.a}{hyperparameter for conjugate prior on variance term, i.e., \eqn{\sigma^2 \sim IG(a,b)}. Note that \eqn{b} is chosen appropriately as in paper.}

\item{par.alpha}{hyperparameter for conjugate prior on diagonal term, i.e., \eqn{\lambda_j \sim IG(\alpha, \beta_j)}. Note that \eqn{\beta_j} is chosen appropriately as in paper.}

\item{par.step}{stepsize for random-walk, which is standard deviation of Gaussian proposal.}

\item{mc.iter}{the number of MCMC iterations.}

\item{preprocess}{an additional option for preprocessing the data.
Default is "null". See also \code{\link{aux.preprocess}} for more details.}

\item{print.progress}{a logical; \code{TRUE} to show iterations, \code{FALSE} otherwise.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
}
}
\description{
A Bayesian formulation of classical Multidimensional Scaling is presented.
Even though this method is based on MCMC sampling, we only return maximum a posterior (MAP) estimate
that maximizes the posterior distribution. Due to its nature without any special tuning,
increasing \code{mc.iter} requires much computation. A note on the method is that
this algorithm does not return an explicit form of projection matrix so it's
classified in our package as a nonlinear method. Also, automatic dimension selection is not supported
for simplicity as well as consistency with other methods in the package.
}
\examples{
\donttest{
## load iris data
data(iris)
X     = as.matrix(iris[,1:4])
label = as.factor(iris$Species)

## try different maximum number of iterations
out1 <- do.bmds(X, ndim=2, mc.iter=100)
out2 <- do.bmds(X, ndim=2, mc.iter=500)
out3 <- do.bmds(X, ndim=2, mc.iter=1000)

## visualize
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,3))
plot(out1$Y, main="BMDS::iter=100",  col=label)
plot(out2$Y, main="BMDS::iter=500",  col=label)
plot(out3$Y, main="BMDS::iter=1000", col=label)
par(opar)
}

}
\references{
\insertRef{oh_bayesian_2001}{Rdimtools}
}
\author{
Kisung You
}
