% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_AMMC.R
\name{do.ammc}
\alias{do.ammc}
\title{Adaptive Maximum Margin Criterion}
\usage{
do.ammc(
  X,
  label,
  ndim = 2,
  preprocess = c("center", "scale", "cscale", "decorrelate", "whiten"),
  a = 1,
  b = 1,
  lambda = 1
)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations
and columns represent independent variables.}

\item{label}{a length-\eqn{n} vector of data class labels.}

\item{ndim}{an integer-valued target dimension.}

\item{preprocess}{an additional option for preprocessing the data.
Default is "center". See also \code{\link{aux.preprocess}} for more details.}

\item{a}{tuning parameter for between-class weight in \eqn{[0,\infty)}.}

\item{b}{tuning parameter for within-class weight in \eqn{[0,\infty)}.}

\item{lambda}{balance parameter for between-class and within-class scatter matrices in \eqn{(0,\infty)}.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
\item{projection}{a \eqn{(p\times ndim)} whose columns are basis for projection.}
}
}
\description{
Adaptive Maximum Margin Criterion (AMMC) is a supervised linear dimension reduction method.
The method uses different weights to characterize the different contributions of the
training samples embedded in MMC framework. With the choice of  \code{a=0}, \code{b=0}, and
\code{lambda=1}, it is identical to standard MMC method.
}
\examples{
## load iris data
data(iris)
X     = as.matrix(iris[,1:4])
label = as.factor(iris$Species)

## try different lambda values
out1 = do.ammc(X, label, lambda=0.1)
out2 = do.ammc(X, label, lambda=1)
out3 = do.ammc(X, label, lambda=10)

## visualize
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,3))
plot(out1$Y, main="AMMC::lambda=0.1", pch=19, cex=0.5, col=label)
plot(out2$Y, main="AMMC::lambda=1",   pch=19, cex=0.5, col=label)
plot(out3$Y, main="AMMC::lambda=10",  pch=19, cex=0.5, col=label)
par(opar)

}
\references{
\insertRef{lu_adaptive_2011}{Rdimtools}
}
\seealso{
\code{\link{do.mmc}}
}
\author{
Kisung You
}
