% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_Ustat.R
\name{est.Ustat}
\alias{est.Ustat}
\title{ID Estimation with Convergence Rate of U-statistic on Manifold}
\usage{
est.Ustat(X, maxdim = min(ncol(X), 15))
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations.}

\item{maxdim}{maximum possible dimension allowed for the algorithm to investigate.}
}
\value{
a named list containing containing \describe{
\item{estdim}{estimated intrinsic dimension.}
}
}
\description{
\eqn{U}-statistic is built upon theoretical arguments with the language of
smooth manifold. The convergence rate of the statistic is achieved as a proxy
for the estimated dimension by, at least partially, considering
the scale and influence of extrinsic curvature. The method returns \emph{integer} valued
estimate in that there is no need for rounding the result for practical usage.
}
\examples{
\donttest{
## create 3 datasets of intrinsic dimension 2.
X1 = aux.gensamples(dname="swiss")
X2 = aux.gensamples(dname="ribbon")
X3 = aux.gensamples(dname="saddle")

## acquire an estimate for intrinsic dimension
out1 = est.Ustat(X1)
out2 = est.Ustat(X2)
out3 = est.Ustat(X3)

## print the results
sprintf("* est.Ustat : estimated dimension for 'swiss'  data is \%d.",out1$estdim)
sprintf("* est.Ustat : estimated dimension for 'ribbon' data is \%d.",out2$estdim)
sprintf("* est.Ustat : estimated dimension for 'saddle' data is \%d.",out3$estdim)
}

}
\references{
\insertRef{hein_intrinsic_2005}{Rdimtools}
}
\author{
Kisung You
}
