% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_CRP.R
\name{do.crp}
\alias{do.crp}
\title{Collaborative Representation-based Projection}
\usage{
do.crp(X, ndim = 2, preprocess = c("center", "scale", "cscale",
  "decorrelate", "whiten"), lambda = 1)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations}

\item{ndim}{an integer-valued target dimension.}

\item{preprocess}{an additional option for preprocessing the data.
Default is "center". See also \code{\link{aux.preprocess}} for more details.}

\item{lambda}{regularization parameter for constructing \eqn{\ell_2} graph.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
\item{projection}{a \eqn{(p\times ndim)} whose columns are basis for projection.}
}
}
\description{
Collaborative Representation-based Projection (CRP) is an unsupervised linear
dimension reduction method. Its embedding is based on \eqn{\ell}_2 graph construction,
similar to that of SPP where sparsity constraint is imposed via \eqn{\ell_1} optimization problem.
Note that though it may be way faster, rank deficiency can pose a great deal of problems,
especially when the dataset is large.
}
\examples{
\dontrun{
## generate samples
X <- aux.gensamples(n=200)

## test different regularization parameters
out1 <- do.crp(X,ndim=2,lambda=0.1)
out2 <- do.crp(X,ndim=2,lambda=1)
out3 <- do.crp(X,ndim=2,lambda=10)

# visualize
par(mfrow=c(1,3))
plot(out1$Y[,1], out1$Y[,2], main="lambda=0.1")
plot(out2$Y[,1], out2$Y[,2], main="lambda=1")
plot(out3$Y[,1], out3$Y[,2], main="lambda=10")
}

}
\seealso{
\code{\link{do.spp}}
}
\author{
Kisung You
}
