% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_correlation.R
\name{est.correlation}
\alias{est.correlation}
\title{Correlation Dimension}
\usage{
est.correlation(X, nlevel = 50, cut = c(0.1, 0.9))
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations.}

\item{nlevel}{the number of \code{r} (radius) to be tested.}

\item{cut}{a vector of ratios for computing estimated dimension in \eqn{(0,1)}.}
}
\value{
a named list containing containing \describe{
\item{estdim}{estimated dimension using \code{cut} values.}
\item{r}{a vector of radius used.}
\item{Cr}{a vector of \eqn{C(r)} as decribed above.}
}
}
\description{
Correlation dimension is a measure of determining the dimension of a given set. It is
often referred to as a type of fractal dimension.  Its mechanism is somewhat similar to
that of box-counting dimension, but has the advantage of being intuitive as well as
efficient in terms of computation with some robustness contingent on the lack of availability for large dataset.
\deqn{dim(S) = \lim \frac{\log C(r)}{\log r}} as \eqn{r\rightarrow 0}, where
\eqn{C(r)=\lim (2/(N-1)*N)\sum_i^N \sum_{j=i+1}^N I(\|x_i-x_j\|\le r)}.
}
\section{Determining the dimension}{

Even though we could use arbitrary \code{cut} to compute estimated dimension, it is also possible to
use visual inspection. According to the theory, if the function returns an \code{output}, we can plot
\code{plot(log(output$r), log(output$Cr))} and use the linear slope in the middle as desired dimension of data.
}

\section{Automatic choice of \eqn{r}}{

The least value for radius \eqn{r} must have non-degenerate counts, while the maximal value should be the
maximum distance among all pairs of data points across all coordinates. \code{nlevel} controls the number of interim points
in a log-equidistant manner.
}

\examples{
\dontrun{
## generate three different dataset
X1 = aux.gensamples(dname="swiss")
X2 = aux.gensamples(dname="ribbon")
X3 = aux.gensamples(dname="twinpeaks")

## compute
out1 = est.correlation(X1)
out2 = est.correlation(X2)
out3 = est.correlation(X3)

## visually verify : all should have approximate slope of 2.
par(mfrow=c(1,3))
plot(log(out1$r), log(out1$Cr), main="swiss roll")
plot(log(out2$r), log(out2$Cr), main="ribbon")
plot(log(out3$r), log(out3$Cr), main="twinpeaks")
}


}
\references{
\insertRef{grassberger_measuring_1983}{Rdimtools}
}
\seealso{
\code{\link{est.boxcount}}
}
\author{
Kisung You
}
