% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nonlinear_KLSDA.R
\name{do.klsda}
\alias{do.klsda}
\title{Kernel Locality Sensitive Discriminant Analysis}
\usage{
do.klsda(X, label, ndim = 2, preprocess = c("center", "whiten",
  "decorrelate"), alpha = 0.5, k1 = max(ceiling(nrow(X)/10), 2),
  k2 = max(ceiling(nrow(X)/10), 2), t = 1)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations
and columns represent independent variables.}

\item{label}{a length-\eqn{n} vector of data class labels.}

\item{ndim}{an integer-valued target dimension.}

\item{preprocess}{an additional option for preprocessing the data.
Default is "center" and other options of "decorrelate" and "whiten"
are supported. See also \code{\link{aux.preprocess}} for more details.}

\item{alpha}{balancing parameter for between- and within-class scatter in \eqn{[0,1]}.}

\item{k1}{the number of same-class neighboring points (homogeneous neighbors).}

\item{k2}{the number of different-class neighboring points (heterogeneous neighbors).}

\item{t}{bandwidth parameter for heat kernel in \eqn{(0,\infty)}.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
}
}
\description{
Kernel LSDA (KLSDA) is a nonlinear extension of LFDA method using kernel trick. It applies conventional kernel method
to extend excavation of hidden patterns in a more flexible manner in tradeoff of computational load. For simplicity,
only the gaussian kernel parametrized by its bandwidth \code{t} is supported.
}
\examples{
## generate 3 different groups of data X and label vector
x1 = matrix(rnorm(4*10), nrow=10)-50
x2 = matrix(rnorm(4*10), nrow=10)
x3 = matrix(rnorm(4*10), nrow=10)+50
X  = rbind(x1, x2, x3)
label = c(rep(1,10), rep(2,10), rep(3,10))

## try different kernel bandwidths
out1 = do.klsda(X, label, k1=10, k2=10, t=1)
out2 = do.klsda(X, label, k1=10, k2=10, t=5)
out3 = do.klsda(X, label, k1=10, k2=10, t=10)

## visualize
par(mfrow=c(1,3))
plot(out1$Y[,1], out1$Y[,2], main="bandwidth=1")
plot(out2$Y[,1], out2$Y[,2], main="bandwidth=15")
plot(out3$Y[,1], out3$Y[,2], main="bandwidth=10")

}
\references{
\insertRef{cai_locality_2007}{Rdimtools}
}
\author{
Kisung You
}
