% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nonlinear_TSNE.R
\name{do.tsne}
\alias{do.tsne}
\title{t-distributed Stochastic Neighbor Embedding}
\usage{
do.tsne(X, ndim = 2, perplexity = 30, eta = 0.05, maxiter = 2000,
  jitter = 0.3, jitterdecay = 0.99, momentum = 0.5, preprocess = "null",
  pca = TRUE, pcaratio = 0.9, pcascale = FALSE, symmetric = FALSE,
  BarnesHut = FALSE, BHtheta = 0.5)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations and columns represent independent variables.}

\item{ndim}{an integer-valued target dimension.}

\item{perplexity}{desired level of perplexity; ranging [5,50].}

\item{eta}{learning parameter.}

\item{maxiter}{maximum number of iterations.}

\item{jitter}{level of white noise added at the beginning.}

\item{jitterdecay}{decay parameter in (0,1). The closer to 0, the faster artificial noise decays.}

\item{momentum}{level of acceleration in learning.}

\item{preprocess}{an additional option for preprocessing the data.
Default is ``null'', and other methods of ``decorrelate'',``center'' , and ``whiten'' are supported. See also \code{\link{aux.preprocess}} for more details.}

\item{pca}{whether to use PCA as preliminary step; \code{TRUE} for using it, \code{FALSE} otherwise.}

\item{pcaratio}{proportion of variances explained in finding PCA preconditioning. See also \code{\link{do.pca}} for more details.}

\item{pcascale}{a logical; \code{FALSE} for using Covariance, \code{TRUE} for using Correlation matrix. See also \code{\link{do.pca}} for more details.}

\item{symmetric}{a logical; \code{FALSE} to solve it naively, and \code{TRUE} to adopt symmetrization scheme.}

\item{BarnesHut}{a logical; \code{FALSE} not to use Barnes-Hut heuristic for faster computation, \code{TRUE} otherwise.}

\item{BHtheta}{a positive real number for speed/accuracy trade-off in Barnes-Hut computation. See also \code{theta} parameter from \code{\link[Rtsne]{Rtsne}}.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
}
}
\description{
t-distributed Stochastic Neighbor Embedding (t-SNE) is a variant of Stochastic Neighbor Embedding (SNE)
that mimicks patterns of probability distributinos over pairs of high-dimensional objects on low-dimesional
target embedding space by minimizing Kullback-Leibler divergence. While conventional SNE uses gaussian
distributions to measure similarity, t-SNE, as its name suggests, exploits a heavy-tailed Student t-distribution.
For \code{do.tsne}, we implemented a naive version of t-SNE as well as an interface with Barnes-Hut algorithm,
which takes advantage of speed in sacrifice of accuracy.
}
\examples{
\dontrun{
## generate "cswiss" data
X = aux.gensamples(dname="cswiss",n=99)

## 1. no pca scaling
output1 <- do.tsne(X,ndim=2,pca=FALSE)

## 2. no pca scaling + small perplexity
output2 <- do.tsne(X,ndim=2,pca=FALSE,perplexity=10)

## 3. no pca scaling + Barnes-Hut scheme
output3 <- do.tsne(X,ndim=2,pca=FALSE,perplexity=5,BarnesHut=TRUE)

## Visualize three different projections
par(mfrow=c(1,3))
if ((length(output1)!=1)&&(!is.na(output1))){plot(output1$Y[,1],output1$Y[,2],main="Setting 1")}
if ((length(output1)!=1)&&(!is.na(output2))){plot(output2$Y[,1],output2$Y[,2],main="Setting 2")}
if ((length(output1)!=1)&&(!is.na(output3))){plot(output3$Y[,1],output3$Y[,2],main="Setting 3")}
}

}
\references{
\insertRef{van_der_maaten_visualizing_2008}{Rdimtools}
}
\seealso{
\code{\link{do.sne}}, \code{\link[Rtsne]{Rtsne}}.
}
\author{
Kisung You
}
