% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nonlinear_MVU.R
\name{do.mvu}
\alias{do.mvu}
\alias{do.sde}
\title{Maximum Variance Unfolding / Semidefinite Embedding}
\usage{
do.mvu(X, ndim = 2, type = c("proportion", 0.1), preprocess = "null",
  projtype = "spectral")
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations and columns represent independent variables.}

\item{ndim}{an integer-valued target dimension.}

\item{type}{a vector of neighborhood graph construction. Following types are supported;
\code{c("knn",k)}, \code{c("enn",radius)}, and \code{c("proportion",ratio)}.
Default is \code{c("proportion",0.1)}, connecting about 1/10 of nearest data points
among all data points. See also \code{\link{aux.graphnbd}} for more details.}

\item{preprocess}{an additional option for preprocessing the data.
Default is ``null'', and other methods of ``decorrelate'',``center'' , and ``whiten'' are supported. See also \code{\link{aux.preprocess}} for more details.}

\item{projtype}{type of method for projection; either \code{"spectral"} or \code{"kpca"} used.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
}
}
\description{
The method of Maximum Variance Unfolding(MVU), also known as Semidefinite Embedding(SDE) is, as its names suggest,
to exploit semidefinite programming in performing nonlinear dimensionality reduction by \emph{unfolding}
neighborhood graph constructed in the original high-dimensional space. Its unfolding generates a gram
matrix \eqn{K} in that we can choose from either directly finding embeddings (\code{"spectral"}) or
use again Kernel PCA technique (\code{"kpca"}) to find low-dimensional representations. Note that
since \code{do.mvu} depends on \href{https://CRAN.R-project.org/package=Rcsdp}{Rcsdp}, we cannot guarantee its computational
efficiency when given a large dataset.
}
\examples{
## generate ribbon-shaped data
## in order to pass CRAN pretest, n is set to be small.
X = aux.gensamples(dname="ribbon",n=28)

## 1. standard MVU
output1 <- do.mvu(X,ndim=2)

## 2. standard setting with "kpca"-type projection
output2 <- do.mvu(X,ndim=2,projtype="kpca")

## 3. standard MVU for densly connected graph
output3 <- do.mvu(X,ndim=2,type=c("proportion",0.5))

## Visualize three different projections
par(mfrow=c(1,3))
plot(output1$Y[,1],output1$Y[,2],main="standard")
plot(output2$Y[,1],output2$Y[,2],main="kpca projection")
plot(output3$Y[,1],output3$Y[,2],main="densely connected graph")

}
\references{
\insertRef{weinberger_unsupervised_2006}{Rdimtools}
}
\author{
Kisung You
}
