% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_OPLS.R
\name{do.opls}
\alias{do.opls}
\title{Orthogonal Partial Least Squares}
\usage{
do.opls(data1, data2, ndim = 2)
}
\arguments{
\item{data1}{an \code{(n-by-N)} data matrix whose rows are observations.}

\item{data2}{an \code{(n-by-M)} data matrix whose rows are observations.}

\item{ndim}{an integer-valued target dimension.}
}
\value{
a named list containing
\describe{
\item{Y}{an \code{(n-by-ndim)} matrix of projected observations from \code{data1}.}
\item{projection}{a \code{(N-by-ndim)} whose columns are loadings for \code{data1}.}
\item{trfinfo}{a list containing information for out-of-sample prediction for \code{data1}.}
\item{eigvals}{a vector of eigenvalues for iterative decomposition.}
}
}
\description{
Also known as multilinear regression or semipenalized CCA, Orthogonal Partial Least Squares (OPLS)
was first used to perform multilinear ordinary least squares. In its usage, unlike PLS or CCA,
OPLS does not rely on projected variance of response -or, \code{data2}. Instead, it exploits projected
variance of input - covariance of \code{data1} and relates it under cross-covariance setting. Therefore,
OPLS only returns projection information of \code{data1}, just like any other unsupervised methods in our package.
}
\examples{
## generate 2 normal data matrices
mat1 = matrix(rnorm(100*12),nrow=100)+10 # 12-dim normal
mat2 = matrix(rnorm(100*6), nrow=100)-10 # 6-dim normal

## compare OPLS and PLS
res_opls = do.opls(mat1, mat2, ndim=2)
res_pls  = do.pls(mat1, mat2, ndim=2)

## visualize
par(mfrow=c(1,2))
plot(res_opls$Y[,1], res_opls$Y[,2], main="OPLS result")
plot(res_pls$Y1[,1], res_pls$Y1[,2], main="PLS result")

}
\references{
\insertRef{barker_partial_2003}{Rdimtools}
}
\seealso{
\code{\link{do.pls}}
}
\author{
Kisung You
}
